theory question_27_0

imports Main

begin

typedecl entity
typedecl event

consts
  Man :: "entity ⇒ bool"
  Old :: "entity ⇒ bool"
  HardwareParts :: "entity ⇒ bool"
  Sells :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Sidewalk :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Dirty :: "entity ⇒ bool"

theorem hypothesis:
  (* Premise: A old man sells hardware parts on a dirty sidewalk. *)
  assumes asm: "Man x ∧ Old x ∧ HardwareParts y ∧ Sells e ∧ Agent e x ∧ Patient e y ∧ Sidewalk z ∧ Dirty z ∧ On x z"
  (* Hypothesis: The man is outside. *)
  shows "∃x. Man x ∧ Outside x"
proof -
  from asm have "Sidewalk z" by blast
  then have "On x z" using asm by blast
  then have "Outside x" by fact
  then show ?thesis using asm by blast
qed

end
