theory question_72_1
imports Main

begin

typedecl entity
typedecl event
typedecl real

consts
  Friction :: "entity ⇒ bool"
  Object :: "entity ⇒ bool"
  Surface :: "entity ⇒ bool"
  Moving :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Acts :: "event ⇒ bool"
  Counter :: "event ⇒ event ⇒ bool"
  Reduce :: "event ⇒ event ⇒ bool"
  Stop :: "event ⇒ event ⇒ bool"
  Resist :: "event ⇒ event ⇒ bool"
  Riding :: "event ⇒ bool"
  Over :: "event ⇒ entity ⇒ entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"
  Wagon :: "entity ⇒ bool"
  Vehicle :: "entity ⇒ bool"
  Human :: "entity ⇒ bool"
  Rides :: "entity ⇒ entity ⇒ bool"
  Child :: "entity ⇒ bool"
  YoungHuman :: "entity ⇒ bool"
  Touching :: "entity ⇒ entity ⇒ bool"
  Speed :: "entity ⇒ real"
  Causing :: "event ⇒ bool"
  Decrease :: "event ⇒ real ⇒ bool"

(* Explanation 1: Friction acts to counter the motion of an object when its surface is moving against, over, or down another surface. *)
axiomatization where
  explanation_1: "∀x y z e1 e2. Friction x ∧ Object y ∧ Surface z ∧ Moving e1 ∧ Agent e1 y ∧ Patient e1 z ⟶ Counter e2 e1 ⟹ Agent e2 x ∧ Patient e2 y"

(* Explanation 2: A surface is a part of an object. *)
axiomatization where
  explanation_2: "∀x y. Surface x ⟶ PartOf x y ∧ Object y"

(* Explanation 3: A wagon is a kind of vehicle. *)
axiomatization where
  explanation_3: "∀x. Wagon x ⟶ Vehicle x"

(* Explanation 4: Counter means reduce; stop; resist. *)
axiomatization where
  explanation_4: "∀x y z. Counter x y ⟷ (Reduce x y ∨ Stop x y ∨ Resist x y)"

(* Explanation 5: Riding something is moving that thing over a surface. *)
axiomatization where
  explanation_5: "∀x y z e1 e2. Riding e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ (∃e2. Moving e2 ∧ Agent e2 x ∧ Patient e2 y ∧ Over e2 y z ∧ Surface z)"

(* Explanation 6: Riding is a kind of motion. *)
axiomatization where
  explanation_6: "∀x. Riding x ⟶ Motion x"

(* Explanation 7: Humans ride vehicles. *)
axiomatization where
  explanation_7: "∀x y. Human x ∧ Vehicle y ⟶ Rides x y"

(* Explanation 8: A child is a kind of young human. *)
axiomatization where
  explanation_8: "∀x. Child x ⟶ YoungHuman x"

(* Explanation 9: If one surface is moved against, moved over, or moved down another surface, then those surfaces are touching. *)
axiomatization where
  explanation_9: "∀x y z e1. Moving e1 ∧ Agent e1 x ∧ Patient e1 y ∧ (Against e1 y z ∨ Over e1 y z ∨ Down e1 y z) ∧ Surface y ∧ Surface z ⟶ Touching y z"

(* Explanation 10: Motion means moving. *)
axiomatization where
  explanation_10: "∀x. Motion x ⟷ Moving x"

(* Explanation 11: A vehicle is a kind of object. *)
axiomatization where
  explanation_11: "∀x. Vehicle x ⟶ Object x"

(* Explanation 12: Friction causes the speed of an object to decrease when the surfaces are touching. *)
axiomatization where
  explanation_12: "∀x y z e1 e2. Friction x ∧ Object y ∧ Surface z ∧ Touching y z ∧ Causing e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ (∃e2. Decrease e2 (Speed y) ∧ Agent e2 x)"

(* Explanation 13: Stop means zero speed. *)
axiomatization where
  explanation_13: "∀x. Stop x ⟷ Speed x = 0"

theorem hypothesis:
  (* Premise: a child rides a wagon down a hill. *)
  assumes asm: "Child x ∧ Wagon y ∧ Hill z ∧ Riding e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Down e1 y z"
  (* Premise: eventually, the wagon comes to a stop. *)
  assumes asm2: "∃x e1. Wagon x ∧ Stop e1 ∧ Agent e1 x ∧ Patient e1 x"
  (* Hypothesis: Friction acting on the wagon is responsible for causing the wagon to stop. *)
  shows "∃x y e1 e2. Friction x ∧ Wagon y ∧ Acting e1 ∧ Agent e1 x ∧ Patient e1 y ∧  Causing e2 ∧ Agent e2 x ∧ Patient e2 y ∧ Stop e2 y "
proof -
  {
    assume asm: "Child x ∧ Wagon y ∧ Hill z ∧ Riding e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Down e1 y z"
    assume asm2: "∃x e1. Wagon x ∧ Stop e1 ∧ Agent e1 x ∧ Patient e1 x"
    from asm have "Moving e1" and "Over e1 y z" and "Surface z" using explanation_5 by blast
    then have "Touching y z" using explanation_9 by blast
    from asm2 obtain w e2 where w_e2: "Wagon w ∧ Stop e2 ∧ Agent e2 w ∧ Patient e2 w" by blast
    from explanation_12[OF asm, where x=x, y=w, z=z, e1=e1, e2=e2]
    have "Friction x ∧ Wagon w ∧ Acting e1 ∧ Agent e1 x ∧ Patient e1 w ∧ Causing e2 ∧ Agent e2 x ∧ Patient e2 w ∧ Stop e2 w"
      by (metis (mono_tags, lifting) asm w_e2)
  }
  then show ?thesis by blast
qed

end
