theory question_93_5

imports Main

begin

typedecl entity
typedecl event

consts
  AdultEchinoderms :: "entity ⇒ bool"
  RadialSymmetry :: "entity ⇒ bool"
  Starfish :: "entity ⇒ bool"
  Echinoderms :: "entity ⇒ bool"
  AdultStarfish :: "entity ⇒ bool"

(* Explanation 1: Adult echinoderms have radial symmetry. *)
axiomatization where
  explanation_1: "∀x. AdultEchinoderms x ⟶ RadialSymmetry x"

(* Explanation 2: Starfish are a type of echinoderm, and all adults of starfish are echinoderms that exhibit radial symmetry. *)
axiomatization where
  explanation_2: "∀x. Starfish x ⟶ Echinoderms x ∧ (∀y. AdultStarfish y ∧ y = x ⟶ RadialSymmetry y)"

theorem hypothesis:
  assumes asm: "AdultStarfish x"
  (* Hypothesis: Adults of starfish have radial symmetry. *)
  shows "RadialSymmetry x"
proof -
  from asm have "AdultStarfish x" by simp
  then have "Echinoderms x" using explanation_2 by blast
  then have "AdultEchinoderms x" using explanation_2 by blast
  then have "RadialSymmetry x" using explanation_1 by blast
  show ?thesis using asm `RadialSymmetry x` by blast
qed

end
