theory question_63_1

imports Main

begin

typedecl entity
typedecl event

consts
  Rocks :: "entity ⇒ bool"
  SedimentaryRocks :: "entity ⇒ bool"
  Deposition :: "event ⇒ bool"
  FormedBy :: "entity ⇒ event ⇒ bool"
  Sandstone :: "entity ⇒ bool"

(* Explanation 1: Sedimentary rocks are formed by deposition. *)
axiomatization where
  explanation_1: "∀x e. SedimentaryRocks x ⟶ (∃e. Deposition e ∧ FormedBy x e)"

(* Explanation 2: Sandstone is a common type of sedimentary rock formed by deposition. *)
axiomatization where
  explanation_2: "∀x e. Sandstone x ⟶ (∃e. SedimentaryRocks x ∧ Deposition e ∧ FormedBy x e)"

theorem hypothesis:
  assumes asm: "Rocks x ∧ Deposition e ∧ FormedBy x e"
  (* Hypothesis: Rocks formed by deposition are sandstone. *)
  shows "Sandstone x"
proof -
  from asm have "Deposition e ∧ FormedBy x e" by simp
  then obtain r where r: "SedimentaryRocks r ∧ Deposition e ∧ FormedBy r e" using explanation_1 by blast
  then have "Sandstone x" using explanation_2 r by blast
  show ?thesis using asm r by blast
qed

end
