theory question_81_0
imports Main

begin
typedecl entity
typedecl event

consts
  Bike :: "entity ⇒ bool"
  Bicycle :: "entity ⇒ bool"
  Person :: "entity ⇒ bool"
  Outside :: "entity ⇒ bool"
  SoaringOver :: "entity ⇒ entity ⇒ bool"
  Ground :: "entity"
  Helmet :: "entity ⇒ bool"
  Skyline :: "entity ⇒ bool"
  Lake :: "entity ⇒ bool"
  Wears :: "event ⇒ entity ⇒ entity ⇒ bool"
  Jumps :: "event ⇒ entity ⇒ bool"
  Has :: "entity ⇒ entity ⇒ bool"
  InFrontOf :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Bike is the short word for bicycle, and the person is outside if the person is soaring over something. *)
axiomatization where
  explanation_1: "∀x y. Bike x ⟷ Bicycle x ∧ ∀z. Person z ∧ Outside z ⟷ (∃w. SoaringOver z w)"

theorem hypothesis:
  (* Premise: A person on a bicycle wears a helmet and jumps, soaring over the ground in front of a skyline and lake. *)
  assumes asm: "Person x ∧ Bicycle y ∧ Helmet z ∧ Skyline w1 ∧ Lake w2 ∧ Wears e1 x z ∧ Jumps e2 x ∧ SoaringOver e3 x Ground ∧ InFrontOf x w1 ∧ InFrontOf x w2"
  (* Hypothesis: A person outside with a bike. *)
  shows "∃x y. Person x ∧ Bike y ∧ Outside x ∧ Has x y"
proof -
  {
    assume "Person x ∧ Bicycle y ∧ Helmet z ∧ Skyline w1 ∧ Lake w2 ∧ Wears e1 x z ∧ Jumps e2 x ∧ SoaringOver e3 x Ground ∧ InFrontOf x w1 ∧ InFrontOf x w2"
    then have "Person x" by blast
    then have "∃w. SoaringOver x w" using explanation_1 by blast
    then have "Outside x" by blast
    then have "Bike y" using explanation_1 by blast
    then have "Has x y" by blast
  }
  then show "∃x y. Person x ∧ Bike y ∧ Outside x ∧ Has x y" by blast
qed

end
