theory question_30_2

imports Main

begin
typedecl entity
typedecl event
consts
  Human :: "entity ⇒ bool"
  Man :: "entity ⇒ bool"
  Skateboard :: "entity ⇒ bool"
  TricksOn :: "entity ⇒ entity ⇒ bool"
  DoingTricksOn :: "event ⇒ entity ⇒ bool"
  DoingTricks :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation: If someone is tricks on something, it can be assumed that they are doing tricks on that thing. *)
axiomatization where
  explanation: "∀x y e. TricksOn x y ∧ DoingTricksOn e y ∧ Agent e x ⟹ DoingTricks e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  (* Premise: A man is doing tricks on a skateboard. *)
  assumes asm: "Man x ∧ Skateboard y ∧ DoingTricksOn e y ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: A human doing tricks *)
  shows "∃x e. Human x ∧ DoingTricks e ∧ Agent e x"
proof -
  {
    assume asm: "Man x ∧ Skateboard y ∧ DoingTricksOn e y ∧ Agent e x ∧ Patient e y"
    from asm have "Man x" by blast
    from this have "Human x" using ‹∀x. Man x ⟹ Human x› by blast
    from asm have "TricksOn x y" using ‹∀x y. DoingTricksOn e y ∧ Agent e x ⟹ TricksOn x y› by blast
    from asm have "DoingTricks e" using ‹∀x y e. TricksOn x y ∧ DoingTricksOn e y ∧ Agent e x ⟹ DoingTricks e ∧ Agent e x ∧ Patient e y› by blast
    from asm have "Agent e x" by blast
  }
  then show ?thesis using ‹Human x› ‹DoingTricks e› ‹Agent e x› by blast
qed

end
