theory question_66_1

imports Main

begin

typedecl entity
typedecl event

consts
  Sun :: "entity ⇒ bool"
  Star :: "entity ⇒ bool"
  Emit :: "event ⇒ entity ⇒ bool ⇒ bool"
  HighTemperature :: "entity ⇒ bool"
  Hottest :: "entity ⇒ bool"

(* Explanation 1: The Sun is a kind of star that emits heat and light. *)
axiomatization where
  explanation_1: "∀x. Sun x ∧ Star x ∧ Emit x Heat ∧ Emit x Light"

(* Explanation 2: Stars are some of the hottest objects due to their high temperatures. *)
axiomatization where
  explanation_2: "∀x. Star x ∧ HighTemperature x ⟶ Hottest x"  

theorem hypothesis:
  assumes asm: "Sun x ∧ Earth y ∧ Mars z ∧ Moon z"
  (* Hypothesis: The Sun is the hottest among the Earth, Mars, and the Moon. *)
  shows "∃x y z e. Sun x ∧ Earth y ∧ Mars z ∧ Moon z ∧ Hottest e"
proof -
  from asm have "Sun x ∧ Earth y ∧ Mars z ∧ Moon z" by simp
  then obtain e1 where e1: "Emit x Heat ∧ Emit x Light" using explanation_1 by blast
  then have "HighTemperature x" using e1 by simp
  then have "Hottest e" using explanation_2 by blast
  show ?thesis using asm e1 e2 by blast
qed

end
