theory question_90_10

imports Main

begin

typedecl entity
typedecl event

consts
 Worker :: "entity ⇒ bool"
 BentOver :: "entity ⇒ bool"
 Activity :: "entity ⇒ bool"
 Pulled :: "event ⇒ bool"
 Agent :: "event ⇒ entity ⇒ bool"
 Patient :: "event ⇒ entity ⇒ bool"
 In :: "event ⇒ entity ⇒ bool"
 EngagedIn :: "event ⇒ bool"
 IfThen :: "event ⇒ bool ⇒ bool ⇒ bool"

(* Premise: Three workers bent over pulling grass. *)
assumes asm: "Worker x  ∧ BentOver y  ∧ Grass z  ∧ Pulled e  ∧ Agent e  x  ∧ Patient e  y  ∧ In e  z "

(* Hypothesis: A worker is engaged in the activity of pulling grass. *)
shows "∃x y e. Worker x  ∧ Activity y  ∧ EngagedIn e  ∧ Agent e  x  ∧ Patient e  y "
proof -
 from asm have "Worker x" by blast
 from this have "Activity y" using explanation_1 by blast
 from asm have "BentOver z" by blast
 from this have "EngagedIn e" using explanation_2 by blast
 from asm have "Pulled e" by blast
 show ?thesis using `Worker x` `Activity y` `BentOver z` `EngagedIn e` `Pulled e` by blast
qed

end
