theory question_67_1

imports Main

begin

typedecl entity
typedecl event

consts
 Male :: "entity ⇒ bool"
 Boat :: "entity ⇒ bool"
 Tour :: "event ⇒ bool"
 Exists :: "entity ⇒ bool"
 Sitting :: "event ⇒ bool"
 Agent :: "event ⇒ entity ⇒ bool"
 In :: "event ⇒ entity ⇒ bool"

(* Explanation 1: If two males are sitting together on a boat, they are on a river boat tour, and the boat exists. *)
axiomatization where
 explanation_1: "∀x y z e. Male x ∧ Male y ∧ Boat z ∧ Tour z ∧ Exists z ∧ Sitting e ∧ Agent e x ∧ Agent e y ∧ In e z"

theorem hypothesis:
 (* Premise: Two older males sitting together on a river boat tour. *)
 assumes asm: "Male x  ∧ Male y  ∧ RiverBoatTour z  ∧ Older x  y  ∧ Sitting e  ∧ Agent e  x  ∧ Agent e  y  ∧ In e  z "
 (* Hypothesis: Two males sitting together on a boat. *)
 shows "∃x y e. Male x  ∧ Male y  ∧ Boat e  ∧ Sitting e  ∧ Agent e  x  ∧ Agent e  y "
proof -
 from asm have "Male x ∧ Male y ∧ RiverBoatTour z ∧ Older x ∧ Sitting e ∧ Agent e x ∧ Agent e y ∧ In e z" by blast
 then have "Male x ∧ Male y ∧ Boat e ∧ Sitting e ∧ Agent e x ∧ Agent e y" using explanation_1 by blast
 then show ?thesis using `Male x` `Male y` `Boat e` `Sitting e` `Agent e x` `Agent e y` by blast
qed

end
