theory question_72_10

imports Main

begin

typedecl entity
typedecl event

consts
  Friction :: "entity ⇒ bool"
  Wagon :: "entity ⇒ bool"
  Object :: "entity ⇒ bool"
  Acts :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Counters :: "event ⇒ bool"
  Touching :: "event ⇒ bool"
  Causes :: "event ⇒ bool"
  Stop :: "entity ⇒ bool"
  Child :: "entity ⇒ bool"
  Hill :: "entity ⇒ bool"
  Rides :: "event ⇒ bool"
  Down :: "event ⇒ entity ⇒ bool"
  Comes :: "event ⇒ bool"
  Acting :: "event ⇒ bool"
  Causing :: "event ⇒ bool"

(* Explanation 1: Friction acts on a wagon and this action counters the motion of the wagon when the wagon's surface is touching another object. *)
axiomatization where
  explanation_1: "∀x y z e1 e2 e3. Friction x ∧ Wagon y ∧ Object z ∧ Acts e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Counters e2 ∧ Agent e2 x ∧ Patient e2 y ∧ Touching e3 ∧ Agent e3 y ∧ Patient e3 z"

(* Explanation 2: If friction acts on a wagon and the wagon's surface is touching another object, it causes the wagon to stop. *)
axiomatization where
  explanation_2: "∀x y z e1 e2 e3. Friction x ∧ Wagon y ∧ Object z ∧ Acts e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Touching e2 ∧ Agent e2 y ∧ Patient e2 z ⟶ Causes e3 ∧ Agent e3 x ∧ Patient e3 y ∧ Stop y"  

theorem hypothesis:
  (* Premise: a child rides a wagon down a hill. *)
  (* Premise: eventually, the wagon comes to a stop. *)
  assumes asm: "Child x ∧ Wagon y ∧ Hill z ∧ Rides e ∧ Agent e x ∧ Patient e y ∧ Down e z" 
                "∃x e. Wagon x ∧ Comes e ∧ Agent e x ∧ Stop x"
  (* Hypothesis: Friction acting on the wagon is responsible for causing the wagon to stop. *)
  shows "∃x y e1 e2. Friction x ∧ Wagon y ∧ Acting e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Causing e2 ∧ Agent e2 x ∧ Patient e2 y ∧ Stop y"
proof -
  from asm have "Wagon y" by simp
  then obtain x z e1 e2 e3 where e1: "Friction x ∧ Acts e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Touching e2 ∧ Agent e2 y ∧ Patient e2 z" using explanation_1 by blast
  then have "Causes e3 ∧ Agent e3 x ∧ Patient e3 y ∧ Stop y" using explanation_2 by blast
  have conclusion: "Acting e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Causing e3 ∧ Agent e3 x ∧ Patient e3 y ∧ Stop y" using e1 by simp
  show ?thesis using asm conclusion `Friction x` `Wagon y` by blast
qed

end
