theory question_63_1

imports Main

begin

typedecl entity
typedecl event

consts
  Rocks :: "entity ⇒ bool"
  Formed :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  ByDeposition :: "event ⇒ bool"
  SedimentaryRocks :: "entity ⇒ bool"
  SedimentaryRock :: "entity ⇒ bool"
  Sandstone :: "entity ⇒ bool"

(* Explanation 1: Rocks are formed by deposition into sedimentary rocks. *)
axiomatization where
  explanation_1: "∀x e. Rocks x ∧ Formed e ∧ Agent e x ∧ ByDeposition e ⟶ SedimentaryRocks x"

(* Explanation 2: One of the commonest rocks formed by deposition, which is a sedimentary rock, is sandstone. *)
axiomatization where
  explanation_2: "∀x e. Rocks x ∧ Formed e ∧ Agent e x ∧ ByDeposition e ∧ SedimentaryRock x ⟶ Sandstone x"  

theorem hypothesis:
  assumes asm: "Rocks x ∧ Formed e ∧ Agent e x ∧ ByDeposition e"
  (* Hypothesis: Rocks formed by deposition are sandstone. *)
  shows "Sandstone x"
proof -
  from asm have "Rocks x ∧ Formed e ∧ Agent e x ∧ ByDeposition e" by simp
  then have "SedimentaryRocks x" using explanation_1 by blast
  then have "Sandstone x" using explanation_2 by blast
  then show ?thesis by simp
qed

end
