theory question_46_0

imports Main

begin
typedecl entity
typedecl event

consts
  Boy :: "entity ⇒ bool"
  Fruit :: "entity ⇒ bool"
  StreetCart :: "entity ⇒ bool"
  StreetVendor :: "entity ⇒ bool"
  Sells :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  From :: "event ⇒ entity ⇒ bool"
  OrangeShirt :: "entity ⇒ bool"

(* Explanation 1: If the boy sells fruit from a street cart, he is a street vendor. *)
axiomatization where
  explanation_1: "∀x y z e. Boy x ∧ Fruit y ∧ StreetCart z ∧ Sells e ∧ Agent e x ∧ Patient e y ∧ From e z ⟶ StreetVendor x"

theorem hypothesis:
  (* Premise: A boy in an orange shirt sells fruit from a street cart. *)
  assumes asm: "Boy x ∧ OrangeShirt x ∧ Fruit y ∧ StreetCart z ∧ Sells e ∧ Agent e x ∧ Patient e y ∧ From e z"
  (* Hypothesis: A boy is a street vendor. *)
  shows "∃x. Boy x ∧ StreetVendor x"
proof -
  from asm have "Boy x ∧ Fruit y ∧ StreetCart z ∧ Sells e ∧ Agent e x ∧ Patient e y ∧ From e z" by blast
  then have "StreetVendor x" using explanation_1 by blast
  from asm have "Boy x" by blast
  then show ?thesis using `Boy x` `StreetVendor x` by blast
qed

end
