theory question_54_0
imports Main

begin
typedecl entity
typedecl event
consts
  Man :: "entity ⇒ bool"
  TennisBall :: "entity ⇒ bool"
  Playing :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Strikes :: "entity ⇒ bool"
  Red :: "entity ⇒ bool"
  Black :: "entity ⇒ bool"
  AboutTo :: "event ⇒ bool"
  Strike :: "entity ⇒ bool"

(* Explanation 1: The man strikes the tennis ball because he is playing tennis. *)
axiomatization where
  explanation_1: "∃x e1 e2. Man x ∧ TennisBall e1 ∧ Playing e2 ∧ Agent e2 x ∧ Patient e2 e1 ∧ Strikes e1"

theorem hypothesis:
  (* Premise: A man in red and black about to strike a tennis ball. *)
  assumes asm: "Man x ∧ Red x ∧ Black x ∧ TennisBall e1 ∧ AboutTo e2 ∧ Agent e2 x ∧ Patient e2 e1 ∧ Strike e1"
  (* Hypothesis: A man is playing tennis. *)
  shows "∃x e. Man x ∧ TennisBall e ∧ Playing e ∧ Agent e x ∧ Patient e e"
proof -
  from asm have "Man x" by blast
  from explanation_1 obtain y e where "Man x ∧ TennisBall y ∧ Playing e ∧ Agent e x ∧ Patient e y ∧ Strikes y" by blast
  then have "Man x ∧ TennisBall y ∧ Playing e ∧ Agent e x ∧ Patient e y" by blast
  then show ?thesis using asm by blast
qed

end
