theory question_100_0

imports Main

begin
typedecl entity
typedecl event

consts
  YoungBoy :: "entity ⇒ bool"
  Child :: "entity ⇒ bool"
  Sprinklers :: "entity ⇒ bool"
  InvolveWater :: "entity ⇒ bool"
  Outside :: "entity ⇒ bool"
  Plays :: "event ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"
  Swimsuit :: "entity ⇒ bool"

(* Explanation 1: A young boy is a child. *)
axiomatization where
  explanation_1: "∀x. YoungBoy x ⟶ Child x"

(* Explanation 2: Sprinklers involve water and the sprinklers are outside. *)
axiomatization where
  explanation_2: "∀x. Sprinklers x ∧ InvolveWater x ∧ Outside x"

theorem hypothesis:
  (* Premise: Young boy in swimsuit plays in sprinklers outside *)
  assumes asm: "YoungBoy x ∧ Swimsuit y ∧ Sprinklers z ∧ Plays e ∧ Agent e x ∧ Patient e y ∧ In x z ∧ Outside z"
  (* Hypothesis: A child outside in water. *)
  shows "∃x y. Child x ∧ Outside x ∧ InvolveWater y"
proof -
  from asm have "YoungBoy x" by blast
  from this and explanation_1 have "Child x" by blast
  from asm have "Sprinklers z ∧ InvolveWater z ∧ Outside z" using explanation_2 by blast
  then show ?thesis using `Child x` `Outside z` `InvolveWater z` by blast
qed

end
