from sister_terms_similarity.test_sister_terms_oov import test_all_models_on_micro_lists, signtest, wilcoxontest, \
    test_all_models_on_micro_lists_with_bert_vocab


def test_all_models_on_micro_lists_main(model_mappings=None, bert_comparable=False):
    if model_mappings is None:
        pretained_model = 'data/pretrained_embeddings/GoogleNews-vectors-negative300.bin'
        pretained_model_ft = 'data/pretrained_embeddings/cc.en.300.bin'
        model_mappings = {
            'definnet': ['definnet', pretained_model],
            'fasttext': ['fasttext', pretained_model_ft]
        }

    similarities_function_names = ['res','wup','path']
    root_data_path = "data/similarity_pedersen_test/oov_sister_terms_with_definitions/seed_19"
    if not bert_comparable:
        pretained_model = 'data/pretrained_embeddings/GoogleNews-vectors-negative300.bin'
        model_mappings['additive'] = ['additive_model', pretained_model]
        model_mappings['head'] = ['head_model', pretained_model]

        destination_dir = "results_micro_list"
        spearman_scores = test_all_models_on_micro_lists(model_mappings, root_data_path, destination_dir,
                                                         similarities_function_names=similarities_function_names)
    else:
        model_mappings['defBERT'] = ['defBERT', 'bert-base-uncased']
        model_mappings['BERT_wordpieces'] = ['BERT_wordpieces', 'bert-base-uncased']

        destination_dir = "results_micro_list_comparable"
        spearman_scores = test_all_models_on_micro_lists_with_bert_vocab(model_mappings, root_data_path,
                                                                         destination_dir,
                                                                         similarities_function_names=
                                                                         similarities_function_names)

    test_models = [(target, baseline) for target in ['definnet', 'defBERT'] if target in model_mappings
                   for baseline in [x for x in model_mappings.keys() if x != target]]

    wilcoxontest(spearman_scores, similarities_function_names, test_models)
