"""
Testing Scheme
"""
# Testing with random test dataset
# --test-file-name=dailydialog++ --test-neg-type=random --test-approach=none --test-object=random_negative_responses --target-epoch=N

# Testing with human adversarial test dataset (dailydialog++)
# --test-file-name=dailydialog++ --test-neg-type=human --test-approach=none --test-object=adversarial_negative_responses --target-epoch=N

# Testing with GPT3-generated adversarial test dataset (PNEG)
# --test-file-name=dailydialog_gpt --test-neg-type=gpt --test-approach=direct_wo_ans --test-object=gpt3_negative_responses --target-epoch=N

"""
Testing for experiments
"""
# random baseline
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=random --approach=none --test-file-name=dailydialog++ --test-neg-type=random --test-approach=none --test-object=random_negative_responses --target-epoch=0 --is-shuffle
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=random --approach=none --test-file-name=dailydialog++ --test-neg-type=human --test-approach=none --test-object=adversarial_negative_responses --target-epoch=0 --is-shuffle
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=random --approach=none --test-candidate-num=11 --test-file-name=dailydialog++ --test-neg-type=all --test-approach=none --test-object=adversarial_negative_responses --target-epoch=0 --is-shuffle

# human baseline
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=human --approach=none --test-file-name=dailydialog++ --test-neg-type=random --test-approach=none --test-object=random_negative_responses --target-epoch=1 --is-shuffle
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=human --approach=none --test-file-name=dailydialog++ --test-neg-type=human --test-approach=none --test-object=adversarial_negative_responses --target-epoch=1 --is-shuffle
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=human --approach=none --test-candidate-num=11 --test-file-name=dailydialog++ --test-neg-type=all --test-approach=none --test-object=adversarial_negative_responses --target-epoch=1 --is-shuffle

# PNEG
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-file-name=dailydialog++ --test-neg-type=random --test-approach=none --test-object=random_negative_responses --target-epoch=1 --is-shuffle
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-file-name=dailydialog++ --test-neg-type=human --test-approach=none --test-object=adversarial_negative_responses --target-epoch=1 --is-shuffle
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-candidate-num=11 --test-file-name=dailydialog++ --test-neg-type=all --test-approach=none --test-object=adversarial_negative_responses --target-epoch=1 --is-shuffle

"""
Testing for experiments
"""
# random baseline
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=random --approach=none --test-candidate-num=11 --test-file-name=dailydialog++ --test-neg-type=all --test-approach=none --test-object=adversarial_negative_responses --target-epoch=0

# human baseline
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=human --approach=none --test-candidate-num=11 --test-file-name=dailydialog++ --test-neg-type=all --test-approach=none --test-object=adversarial_negative_responses --target-epoch=1

# PNEG
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-candidate-num=11 --test-file-name=dailydialog++ --test-neg-type=all --test-approach=none --test-object=adversarial_negative_responses --target-epoch=1
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-candidate-num=11 --test-file-name=dailydialog++ --test-neg-type=all --test-approach=none --test-object=adversarial_negative_responses --target-epoch=1 --is-curriculum
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-candidate-num=11 --test-file-name=dailydialog++ --test-neg-type=all --test-approach=none --test-object=adversarial_negative_responses --target-epoch=1 --train-num-hard-negs=4
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-candidate-num=11 --test-file-name=dailydialog++ --test-neg-type=all --test-approach=none --test-object=adversarial_negative_responses --target-epoch=1 --train-num-hard-negs=3
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-candidate-num=11 --test-file-name=dailydialog++ --test-neg-type=all --test-approach=none --test-object=adversarial_negative_responses --target-epoch=1 --train-num-hard-negs=2
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-candidate-num=11 --test-file-name=dailydialog++ --test-neg-type=all --test-approach=none --test-object=adversarial_negative_responses --target-epoch=1 --train-num-hard-negs=1

"""
Testing for experiments (hard neg num changes)
"""
# # # PNEG + weight decay + lr_scheduling + hard_neg=4
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-file-name=dailydialog++ --test-neg-type=random --test-approach=none --test-object=random_negative_responses --target-epoch=1 --train-num-hard-negs=4
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-file-name=dailydialog++ --test-neg-type=human --test-approach=none --test-object=adversarial_negative_responses --target-epoch=1 --train-num-hard-negs=4
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-file-name=dailydialog_gpt --test-neg-type=gpt --test-approach=direct_wo_ans --test-object=gpt3_negative_responses --target-epoch=1 --train-num-hard-negs=4

# # PNEG + weight decay + lr_scheduling + hard_neg=3
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-file-name=dailydialog++ --test-neg-type=random --test-approach=none --test-object=random_negative_responses --target-epoch=1 --train-num-hard-negs=3
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-file-name=dailydialog++ --test-neg-type=human --test-approach=none --test-object=adversarial_negative_responses --target-epoch=1 --train-num-hard-negs=3
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-file-name=dailydialog_gpt --test-neg-type=gpt --test-approach=direct_wo_ans --test-object=gpt3_negative_responses --target-epoch=1 --train-num-hard-negs=3

# # PNEG + weight decay + lr_scheduling + hard_neg=2
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-file-name=dailydialog++ --test-neg-type=random --test-approach=none --test-object=random_negative_responses --target-epoch=1 --train-num-hard-negs=2
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-file-name=dailydialog++ --test-neg-type=human --test-approach=none --test-object=adversarial_negative_responses --target-epoch=1 --train-num-hard-negs=2
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-file-name=dailydialog_gpt --test-neg-type=gpt --test-approach=direct_wo_ans --test-object=gpt3_negative_responses --target-epoch=1 --train-num-hard-negs=2

# # PNEG + weight decay + lr_scheduling + hard_neg=1
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-file-name=dailydialog++ --test-neg-type=random --test-approach=none --test-object=random_negative_responses --target-epoch=1 --train-num-hard-negs=1
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-file-name=dailydialog++ --test-neg-type=human --test-approach=none --test-object=adversarial_negative_responses --target-epoch=1 --train-num-hard-negs=1
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-file-name=dailydialog_gpt --test-neg-type=gpt --test-approach=direct_wo_ans --test-object=gpt3_negative_responses --target-epoch=1 --train-num-hard-negs=1

"""
Testing for experiments (curriculum learning)
"""
# PNEG + weight decay + lr_scheduling + curriculum_learning
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-file-name=dailydialog++ --test-neg-type=random --test-approach=none --test-object=random_negative_responses --target-epoch=1 --train-num-hard-negs=5 --is-curriculum
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-file-name=dailydialog++ --test-neg-type=human --test-approach=none --test-object=adversarial_negative_responses --target-epoch=1 --train-num-hard-negs=5 --is-curriculum
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-candidate-num=11 --test-file-name=dailydialog++ --test-neg-type=all --test-approach=none --test-object=adversarial_negative_responses --target-epoch=1 --is-curriculum

# PNEG + weight decay + lr_scheduling + curriculum_learning + is_shuffle=True
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-file-name=dailydialog++ --test-neg-type=random --test-approach=none --test-object=random_negative_responses --target-epoch=1 --train-num-hard-negs=5 --is-curriculum --is-shuffle
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-file-name=dailydialog++ --test-neg-type=human --test-approach=none --test-object=adversarial_negative_responses --target-epoch=1 --train-num-hard-negs=5 --is-curriculum --is-shuffle
# CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=direct_wo_ans --test-candidate-num=11 --test-file-name=dailydialog++ --test-neg-type=all --test-approach=none --test-object=adversarial_negative_responses --target-epoch=1 --is-curriculum --is-shuffle

"""
Testing for experiments (maha-distance)
"""
CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=maha_w_gpt --test-file-name=dailydialog++ --test-neg-type=random --test-approach=none --test-object=random_negative_responses --target-epoch=1
CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=maha_w_gpt --test-file-name=dailydialog++ --test-neg-type=human --test-approach=none --test-object=adversarial_negative_responses --target-epoch=1
CUDA_VISIBLE_DEVICES=3 python run_inference.py --lmtype=bert --neg-type=gpt --approach=maha_w_gpt --test-candidate-num=11 --test-file-name=dailydialog++ --test-neg-type=all --test-approach=none --test-object=adversarial_negative_responses --target-epoch=1
