'''
- directory.py
- This file handles general folder operations
'''

# External imports
import os

# Internal imports


'''
----------create----------
- Creates a directory at the desired location, if none exists
-----Inputs-----
- path - The path to create, if it doesn't already exist
-----Output-----
- N/A - This function writes the appropriate directories in the filesystem
'''
def create(path):
    if not os.path.exists(path):
        os.makedirs(path)



'''
----------delete----------
- Deletes a file/directory at the desired location, if one exists
-----Inputs-----
- path - The path to create, if it doesn't already exist
-----Output-----
- N/A - This function deletes the appropriate files/directories in the filesystem
'''
def delete(path):
    if os.path.exists(path):
        os.delete(path)