# AVAST: Attentive VAriational State Tracker for Vision-and-Language Navigation

This is the PyTorch implementation for AVAST: Attentive Variational State Tracker in a Reinforced Navigator

---

## Installation

Clone the Matterport3DSimulator repository:
```bash
git clone --recursive https://github.com/peteanderson80/Matterport3DSimulator.git
cd Matterport3DSimulator
```

Replace original Matterport3DSimulator scripts with our scripts
```bash
rm -r tasks/ Dockerfile README.md
cd ..
unzip <path_to_zip>/AVAST_R2R.zip -d .
```

### Downloading pre-trained embedding and R2R datasets
```bash
cd Matterport3DSimulator
bash download.sh
```

### Downloading Matterport3D Dataset (optional)
To use original Matterport3D simulator you must first download the [Matterport3D Dataset](https://niessner.github.io/Matterport/) which is available after requesting access [here](https://niessner.github.io/Matterport/). The download script that will be provided allows for downloading of selected data types. At minimum you must download the `matterport_skybox_images`. If you wish to use depth outputs then also download `undistorted_depth_images` and `undistorted_camera_parameters`.

Set an environment variable to the location of the **unzipped** dataset, where <PATH> is the full absolute path (not a relative path or symlink) to the directory containing the individual matterport scan directories (17DRP5sb8fy, 2t7WUuJeko7, etc):

```bash
export MATTERPORT_DATA_DIR=<PATH>
```

### Building using Docker
```bash
docker build --rm -t r2r/avast:base .
docker run --name r2r -it --gpus all \
    -e DISPLAY -e="QT_X11_NO_MITSHM=1" -v /tmp/.X11-unix:/tmp/.X11-unix \
    --mount type=bind,source=$MATTERPORT_DATA_DIR,target=/root/mount/Matterport3DSimulator/data/v1/scans \
    --volume `pwd`:/root/mount/Matterport3DSimulator \
    --restart=unless-stopped --shm-size 32G \
    -p <ssh_port>:22 -p <tensorboard_port>:6006 r2r/avast:base
```

### Buiding Matterport3D simulator
Now (from inside the docker container), build the simulator code:
```bash
cd /root/mount/Matterport3DSimulator
mkdir build && cd build
cmake -DEGL_RENDERING=ON ..
make
cd ../
```

---

## Training and evaluation

### Pre-training state trackers
* Pre-training attentive state tracker:
    ```
    python3 ast_pre_train.py --mode pre_train --state_tracker ast --agent seq2seq
    ```
* pre-training attentive variational state tracker:
    ```
    python3 avast_pre_train.py --mode pre_train --state_tracker avast --agent seq2seq
    ```
    
### Fine-tuning an agent with RL algorithms
* Fine-tuning an agent with AST+REINFORCE:
    ```
    python3 reinforce_fine_tune.py --mode train --state_tracker ast --load_pre_trained_dir <ast_path> --agent reinforce
    ```   
* Fine-tuning an agent with AVAST+SACD+RECED:
    ```
    python3 sacd_fine_tune.py --mode train --state_tracker avast --load_pre_trained_dir <avast_path> --agent sacd --demo_activate --curriculum
    ```

### Evaluating an agent
* Evaluating AST+Seq2Seq:
    ```
    python3 ast_pre_train.py --mode test --state_tracker ast --agent seq2seq --load_dir <model_path>
    ```    
* Evaluating AVAST+Seq2Seq:
    ```
    python3 avast_pre_train.py --mode test --state_tracker avast --agent seq2seq --load_dir <model_path>
    ```
* Evaluating AST+REINFORCE:
    ```
    python3 reinforce_fine_tune.py --mode test --state_tracker ast --agent reinforce --load_dir <model_path>
    ```
* Evaluating AVAST+SACD:
    ```
    python3 sacd_fine_tune.py --mode test --state_tracker avast --agent sacd --load_dir <model_path>
    ```