from tqdm import tqdm
from prompt_template_class import GroupingGenerator
from langchain import LLMChain
from langchain.chat_models import ChatOpenAI
from langchain.llms import OpenAI
from api_key import *
from langchain.prompts.chat import SystemMessagePromptTemplate, ChatPromptTemplate
from output_parser import GroupingOutputParser
from data_creator import GroupingDataCreator
import argparse
from utlis import str2bool
from tqdm import tqdm
import random
import numpy as np
from langchain.prompts import PromptTemplate
from utlis import load_llama, get_prompt, B_INST, E_INST

parser = argparse.ArgumentParser()
parser.add_argument("--num_examples", type=int, default=200)
parser.add_argument("--model_name", type=str, default="gpt-3.5-turbo-16k-0613")
parser.add_argument("--few_shot", type=str2bool, default=True)
parser.add_argument("--cot", type=str2bool, default=False)
parser.add_argument("--multiple_run", type=str2bool, default=False)
args = parser.parse_args()
print(args)
#0.733 0.11 0.0 False False
#0.767 0.62 0.0 True False
#
num_polygons = 30  # Generate more polygons
num_rules = 15
sides_options = [3, 4, 5, 6, 7, 8, 9, 10, 11, 12]
colors_options = ['red', 'blue', "while", "black", "yellow", "purple", "gray", "cyan", "brown", "indigo"]
materials_options = ['metal', 'plastic', "glass", "sliver", "gold", "copper", "bronze", "diamond", "jade"]
if "gpt-3.5" in args.model_name or "gpt-4" in args.model_name:
    llm = ChatOpenAI(model=args.model_name, openai_api_key=openai.api_key, temperature=0)
elif "llama" in args.model_name:
    args.model_name = "meta-llama/Llama-2-13b-chat-hf"
    llm = load_llama(args.model_name)
else:
    llm = OpenAI(model=args.model_name, openai_api_key=openai.api_key, temperature=0)
output_parser = GroupingOutputParser()
prompt_generator = GroupingGenerator()
meta_validation_acc = []
meta_average_acc = []
meta_full_acc = []
# Generate polygons and groups
seed_list = [714, 123] if args.multiple_run == True else [714]
for seed in seed_list:
    random.seed(seed)
    grouping_creator = GroupingDataCreator(num_polygons, num_rules, sides_options, colors_options, materials_options)
    acc_list = []
    few_shot_polygons = []
    few_shot_groups = []
    few_shot_noised_groups = []
    few_shot_selected_rules = []
    for _ in range(4):
        if _ <= 1:
            determinstic = "Clean"
        else:
            determinstic = "Noise"
        polygons, groups, selected_rules = grouping_creator.create()
        noised_groups = prompt_generator.noised_groups(groups, determinstic=determinstic)
        few_shot_polygons.append(polygons)
        few_shot_groups.append(groups)
        few_shot_noised_groups.append(noised_groups)
        few_shot_selected_rules.append(selected_rules)

    num_examples = args.num_examples
    validation_count = 0
    incor_correct_count = 0
    incor_example = 0
    full_correct_count = 0
    full_incor_example = 0
    all_prompt = prompt_generator.grouping_validation(few_shot_polygons, few_shot_groups, few_shot_noised_groups,
                                                      few_shot_selected_rules,
                                                      chain_of_thought=args.cot, few_shot=args.few_shot)
    chat_prompt = ChatPromptTemplate.from_messages(all_prompt)
    if "gpt" in args.model_name or "davinci" in args.model_name:
        chain = LLMChain(llm=llm, prompt=chat_prompt)
    else:
        system = ""
        sides_text = str(sides_options).rstrip("]").lstrip("[")
        materials_text = str(materials_options).rstrip("]").lstrip("[")
        colors_text = str(colors_options).rstrip("]").lstrip("[")
        system += chat_prompt.messages[0].format(Colors=colors_text, Materials=materials_text,
                                                 SidesNumber=sides_text).content
        instruction = ""
        example_idx = 0
        if len(chat_prompt.messages) > 2:
            for message in chat_prompt.messages[1:-1]:
                if message.additional_kwargs["name"] == "example_user":
                    if example_idx == 0:
                        instruction += message.format().content + " " + E_INST + " "
                    else:
                        instruction += "<s>" + B_INST + " " +message.format().content + " " +E_INST + " "
                    example_idx += 1
                elif message.additional_kwargs["name"] == "example_assistant":
                    instruction += message.format().content + " " + "</s>\\"+ "\n"
        system += "Additionally, please just output the answer with provided format and don't add any other explanation."
        instruction += chat_prompt.messages[-1].format(Polygons="{Polygons}", Rules="{Rules}",
                                                       GroupingResult="{GroupingResult}"
                                                       ).content
        template = get_prompt(instruction, system)
        prompt = PromptTemplate(template=template, input_variables=["Polygons", "Rules", "GroupingResult"])
        chain = LLMChain(prompt=prompt, llm=llm)
    for _ in tqdm(range(num_examples)):  # Adjust the range for your needs
        polygons, groups_ori_form, selected_rules = grouping_creator.create()
        noised_groups_ori_form = prompt_generator.noised_groups(groups_ori_form)
        polygons_text, sides, materials, colors, noised_results_text, noised_rules_text = prompt_generator.generate_grouping_results(polygons, sides_options,
                                                                                                           colors_options, materials_options, noised_groups_ori_form)
        polygons_text, sides, materials, colors, results_text, rules_text = prompt_generator.generate_grouping_results(polygons,
                                                                                                           sides_options,
                                                                                                           colors_options,
                                                                                                           materials_options,
                                                                                                           groups_ori_form)
        rules_text = prompt_generator.generating_rules(groups_ori_form)
        if "gpt" in args.model_name or "davinci" in args.model_name:
            output = chain.run(Polygons=polygons_text, SidesNumber=sides, Colors=colors, Materials=materials, GroupingResult=noised_results_text,
                           Rules=rules_text)
        else:
            output = chain.run(Polygons=polygons_text,  GroupingResult=noised_results_text,
                           Rules=rules_text)
        print(output)
        pred_validation, pred_validated_group = output_parser.parse_validating(output)
        _, gold_groups = output_parser.parse_validating(results_text)
        _, noised_groups = output_parser.parse_validating(noised_results_text)
        local_correct_count = 0
        if noised_groups_ori_form != groups_ori_form:
            full_incor_example += 1
            for gold_key, noised_key in zip(groups_ori_form.keys(), noised_groups_ori_form.keys()):
                if groups_ori_form[gold_key] != noised_groups_ori_form[noised_key]:
                    incor_example += 1
        if noised_groups_ori_form == groups_ori_form and "Correct" in pred_validation:
            validation_count += 1
        elif noised_groups_ori_form != groups_ori_form and "Incorrect" in pred_validation:
            validation_count += 1
            for pred, gold, noised_group in zip(pred_validated_group, gold_groups, noised_groups):
                if gold != noised_group:
                    if pred == gold:
                        local_correct_count += 1
                        incor_correct_count += 1
        if local_correct_count == 3:
            full_correct_count += 1
        acc_list.append([local_correct_count/len(gold_groups), output, results_text])
    print(f"Validation Accuracy: {str(validation_count/num_examples)}")
    print(f"Partial Explanation Accuracy: {incor_correct_count/incor_example}")
    print(f"Full Explanation Accuracy: {str(full_correct_count/full_incor_example)}")
    print(f"---------------")
    meta_validation_acc.append(validation_count/num_examples)
    meta_average_acc.append(incor_correct_count/incor_example)
    meta_full_acc.append(full_correct_count/full_incor_example)
for idx, validation_acc, average_acc, full_acc in zip(seed_list, meta_validation_acc, meta_average_acc, meta_full_acc):
    print(f"Validation Accuracy: {validation_acc}")
    print(f"Explanation Accuracy: {average_acc}")
    print(f"Full Explanation Accuracy: {full_acc}")
    print(f"------Seed {idx}------")
print("Meta Validation Accuracy: ", np.mean(meta_validation_acc))
print("STD of Meta Validation Accuracy: ", np.std(meta_validation_acc))
print("Meta Partial Explanation Accuracy: ", np.mean(meta_average_acc))
print("STD of Meta Partial Explanation Accuracy: ", np.std(meta_average_acc))
print("Meta Full Explanation Accuracy: ", np.mean(meta_full_acc))
print("STD of Meta Full Explanation Accuracy: ", np.std(meta_full_acc))
