import json
import numpy as np
import random

import json

task_name = 'tweet'
task = 'LaMP_7'
threshold = 50

with open('Private/LoRA-composition/LaMP_data-highly_active/{}/user_all_test.json'.format(task_name), 'r') as f:
    data_100 = json.load(f)

with open('Private/LoRA-composition/LaMP_data-highly_active/{}/user_base_LLM.json'.format(task_name), 'r') as f:
    data_others = json.load(f)

all_user = data_100 + data_others


print('all user')
print(len(all_user))

user_reserve = random.sample(all_user, int(0.1*len(all_user)))

print('user_reserve')
print(len(user_reserve))

with open('Private/LoRA-composition/LaMP_data-final/{}/user_reserve_10_percent.json'.format(task_name), 'w') as f:
    json.dump(user_reserve, f)

user_not_reserve = [user for user in all_user if user not in user_reserve]

print('user not reserve')
print(len(user_not_reserve))

user_more_active = []

for user in user_not_reserve:
    if len(user['profile']) > threshold:
        user_more_active.append(user)

print('user more active: {}'.format(len(user_more_active)))

user_selected = random.sample(user_more_active, 100)

with open('Private/LoRA-composition/LaMP_data-final/{}/test_100/user_test_100.json'.format(task_name), 'w') as f:
    json.dump(user_selected, f)

user_less_active = [user for user in user_not_reserve if user not in user_more_active]


user_base = random.sample(user_less_active, int(len(user_not_reserve)*0.25))

with open('Private/LoRA-composition/LaMP_data-final/{}/user_base_LLM.json'.format(task_name), 'w') as f:
    json.dump(user_base, f)

anchor_candidate = [user for user in user_not_reserve if (user not in user_base and user not in user_selected)]

with open('Private/LoRA-composition/LaMP_data-final/{}/user_anchor_candidate.json'.format(task_name), 'w') as f:
    json.dump(anchor_candidate, f)


output_dict = {
    'task': task,
    'golds': []
}

for i in user_selected:
    for j in i['query']:
        output_dict['golds'].append(
            {
                'id': j['id'],
                'output': j['gold']
            }
        )

with open('Private/LoRA-composition/LaMP_data-final/{}/test_100/user_test_100_label.json'.format(task_name), 'w') as f:
    json.dump(output_dict, f)

