#!/bin/bash
test_ratio=0.9

for random_seed in $(seq 1 10);
do
    for n_att_n_comb_n_dup in \
        "[(1000, 1, 10)]"
    do
        for ce_weight in 0.2; \
        do
            for group_size in 1 2 5 10;
            do
                for n_context in 1000;
                do
                    python EGG/egg/zoo/compo_vs_generalization/train_img_disc.py  \
                        --n_values=10 \
                        --n_attributes=4 \
                        --vocab_size=10 \
                        --max_len=10 \
                        --batch_size=2048 \
                        --val_batch_size=128 \
                        --test_batch_size=2048 \
                        --sender_cell=gru \
                        --sender_emb=5 \
                        --sender_hidden=500 \
                        --sender_entropy_coeff=0.1 \
                        --receiver_cell=gru \
                        --receiver_emb=30 \
                        --receiver_hidden=500 \
                        --n_epoch=1000 \
                        --random_seed $random_seed \
                        --wandb_project=div_int \
                        --wandb_name "n_g${group_size}_c${ce_weight}_t${test_ratio}_d${n_context}_$n_att_n_comb_n_dup" \
                        --lr 0.001 \
                        --data_scaler=1 \
                        --n_att_n_comb_n_dup "$n_att_n_comb_n_dup" \
                        --wandb_tags "[disc_gs_v5]" \
                        --early_stopping_thr 2.99 \
                        --validation_freq=1 \
                        --validation_ratio 0.1 \
                        --test_ratio 0.1 \
                        --stats_freq=25 \
                        --val_eval_freq 1 \
                        --test_eval_freq 1 \
                        --loss_type mixed \
                        --receiver_reset_period 0 \
                        --sender_reset_period 0 \
                        --reset_type uniform \
                        --group_size $group_size \
                        --load_val_best true \
                        --reset_on_epoch true \
                        --eol_n_epochs 25 \
                        --eol_n_attributes "[1000]" \
                        --cross_entropy_weight $ce_weight \
                        --topsim_max_samples 2000 \
                        --dataset_dir data/byol_imagenet2012 \
                        --train_n_samples null \
                        --eval_n_samples null \
                        --add_layer_norm true \
                        --n_context $n_context \
                        --ood_test_ratio $test_ratio \
                        --preserve_eos true \
                        --metric_exclude_eos true \
                        --metric_max_samples 2000 \
                        --abstractness_max_samples 5000 \
                        --use_global_seed true \
                        --n_workers 0
                done 
            done 
        done 
    done 
done 