#!/bin/bash

if [ $# -lt 2 ] ; then
    echo "usage: <train file (CoNLL08)> <model prefix>"
    exit
fi
trn=$1
mod=$2
awk '{for (i = 12; i <= NF; i++) { if ($i != "_") $i = "X";}; print $0}' $trn > $trn.unlab

java -Xmx16g -cp dualdecomp.jar edu.pku.coli.dualdecomp.DualDecompositionTrainer -train $trn.unlab -model $mod.pcd -usemod pcd
java -Xmx16g -cp dualdecomp.jar edu.pku.coli.dualdecomp.DualDecompositionTrainer -train $trn.unlab -model $mod.acd -usemod acd
java -Xmx16g -cp dualdecomp.jar edu.pku.coli.dualdecomp.TreeApproxDecoder conll08 projective X false X -unlab -decode proj -train $trn -model $mod.tad -more_features "-traindepdir $trn.unlab"
