/*
 * Decompiled with CFR 0.152.
 */
package LinguaView.syntax;

import LinguaView.syntax.Attribute;
import LinguaView.syntax.Value;
import java.util.HashSet;
import java.util.Set;

public class SemanticForm
extends Value {
    private String predicate = new String();
    private Set<Attribute> arguments = new HashSet<Attribute>();

    public SemanticForm() {
    }

    public SemanticForm(String pred, String[] args) {
        this.setPred(pred);
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            Attribute attr = new Attribute(arg);
            this.addArgs(attr);
            ++n2;
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof SemanticForm)) {
            return false;
        }
        if (!this.predicate.equals(((SemanticForm)other).predicate)) {
            return false;
        }
        return this.argsEqual((SemanticForm)other);
    }

    private boolean argsEqual(SemanticForm other) {
        return this.argsContainAll(other.arguments) && other.argsContainAll(this.arguments);
    }

    private boolean argsContainAll(Set<Attribute> otherargs) {
        for (Attribute otherarg : otherargs) {
            if (this.argContains(otherarg)) continue;
            return false;
        }
        return true;
    }

    private boolean argContains(Attribute otherarg) {
        for (Attribute arg : this.arguments) {
            if (!arg.equals(otherarg)) continue;
            return true;
        }
        return false;
    }

    public String getPred() {
        return this.predicate;
    }

    public Set<Attribute> getArgs() {
        return this.arguments;
    }

    public String[] getStringArgs() {
        String[] args = new String[this.arguments.size()];
        int i = 0;
        for (Attribute argInAttr : this.arguments) {
            args[i] = argInAttr.getName();
            ++i;
        }
        return args;
    }

    public void setPred(String pred) {
        this.predicate = pred;
    }

    public void addArgs(Attribute attr) {
        this.arguments.add(attr);
    }

    public void addArgs(String arg) {
        Attribute attr = new Attribute(arg);
        this.arguments.add(attr);
    }
}

