"""
Functions:
    This program conducts experiments for ill-formed word detection.
Requirements;
    Put liblinear package (http://www.csie.ntu.edu.tw/~cjlin/liblinear/) in linear folder
    Rename the dependency bank (for detection use) as specified in corpusDict
"""

import os
import sys
import subprocess

#Different corpus
corpusDict = {'gigaword':'../data/gigaword.depbank', 'blog':'../data/blog.depbank'}
#Different expansion weight
expWeight = [0.0, 0.5, 1.0]

print corpusDict
print expWeight
for w in expWeight:
    for corpus in corpusDict:
        # generating training and testing data
        suffix = "{0}{1}".format(corpus, w)
        subprocess.call(['python ./detectionExpDep.py {0} {1} {2}'.format(suffix, corpusDict[corpus], w)], shell=True)
        # clean training data
        subprocess.call('python removeConfliction.py ../dect/train.{0} ../dect/realTrain.{0}'.format(suffix), shell=True)
        # train SVM
        subprocess.call(['../linear/train ../dect/realTrain.{0} ../dect/model.{0}'.format(suffix)], shell=True)
        # test in SVM
        subprocess.call(['../linear/predict ../dect/test.{0} ../dect/model.{0} ../dect/result.{0}'.format(suffix)], shell=True)
        # get result
        for t in range(1, 11):
            subprocess.call(['python ./evalDetection.py {0} {1}'.format(suffix, t)], shell=True)
        print "{0} done!".format(suffix)
