/*
 * Decompiled with CFR 0.152.
 */
package babel.util.jerboa;

import babel.util.jerboa.Hash;
import babel.util.jerboa.LSHSignature;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LSH {
    private static final Log LOG = LogFactory.getLog(LSH.class);
    private static final int NUM_BITS = 256;
    private static final int POOL_SIZE = 100000;
    private double[] m_pool;
    private int[] m_hashes;

    public LSH() {
        try {
            this.m_hashes = Hash.getRandomHashes(256);
            this.m_pool = new double[100000];
            Random random = new Random();
            int i = 0;
            while (i < this.m_pool.length) {
                this.m_pool[i] = random.nextGaussian();
                ++i;
            }
        }
        catch (Exception e) {
            this.m_hashes = null;
            LOG.error((Object)"Failed to instantiate class", (Throwable)e);
        }
    }

    public byte[] buildSignature(HashMap<String, Double> features) {
        float[] sumArray = new float[256];
        byte[] sig = new byte[32];
        for (String feature : features.keySet()) {
            int i = 0;
            while (i < 256) {
                int n = i;
                sumArray[n] = (float)((double)sumArray[n] + features.get(feature) * this.m_pool[Hash.hash(feature, this.m_hashes[i], this.m_pool.length)]);
                ++i;
            }
        }
        int i = 0;
        while (i < 256) {
            int s = 0;
            if (sumArray[i] > 0.0f) {
                s |= 1;
            }
            int j = 1;
            while (j < 8) {
                s <<= 1;
                if (sumArray[i + j] > 0.0f) {
                    s |= 1;
                }
                ++j;
            }
            sig[i / 8] = (byte)s;
            i += 8;
        }
        return sig;
    }

    public static double scoreSignatures(byte[] sigX, byte[] sigY) {
        return LSHSignature.approximateCosine(sigX, sigY);
    }
}

