/*
 * Decompiled with CFR 0.152.
 */
package tsg.metrics;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import tsg.ConstituencyWords;
import tsg.Label;
import tsg.TSNodeLabel;
import tsg.metrics.ParseMetricOptimizer;
import util.Utility;

public class MRuleProductMergeUnary
extends ParseMetricOptimizer {
    static Label noConstLabel = Label.getLabel("");
    static String unaryProductionSeparator = "==";
    static String dotBinarizationMarker = "<dot>";
    Hashtable<CfgFrame, double[]>[][] constsProbTable;
    double sentenceProb;
    ViterbiCell[][] cells;
    static double minusInf = -1.7976931348623157E308;

    public MRuleProductMergeUnary() {
        this.identifier = "MRuleProduct";
    }

    @Override
    protected void initSentence() {
        this.sentenceProb = 0.0;
        this.constsProbTable = new Hashtable[this.sentenceLength][this.sentenceLength];
        this.cells = new ViterbiCell[this.sentenceLength][this.sentenceLength];
        int i = 0;
        while (i < this.sentenceLength) {
            int j = i;
            while (j < this.sentenceLength) {
                this.constsProbTable[i][j] = new Hashtable();
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void addNewDerivationChecked(TSNodeLabel tree, double prob) {
        this.sentenceProb += prob;
        tree.compressUnaryProductions(unaryProductionSeparator, false);
        tree.binarizeEarly(dotBinarizationMarker);
        ArrayList<ConstituencyWords> consts = ConstituencyWords.collectConsituencies(tree, true, new String[0], true);
        for (ConstituencyWords c : consts) {
            TSNodeLabel node = c.getNode();
            Label label = node.label;
            Label leftDaughterLabel = null;
            Label rightDaughterLabel = null;
            if (!node.isPreLexical()) {
                leftDaughterLabel = node.daughters[0].label;
                rightDaughterLabel = node.daughters[1].label;
            }
            CfgFrame mce = new CfgFrame(label, leftDaughterLabel, rightDaughterLabel);
            double ruleProb = label.toString().contains(dotBinarizationMarker) ? 0.0 : prob;
            int startIndex = c.getInitialIndex();
            int endIndex = c.getFinalIndex();
            Hashtable<CfgFrame, double[]> cellTable = this.constsProbTable[startIndex][endIndex];
            Utility.increaseInTableDoubleArray(cellTable, mce, ruleProb);
        }
    }

    @Override
    public TSNodeLabel getBestTree() {
        this.convertCellTableToLog();
        int span = 0;
        while (span < this.sentenceLength) {
            int s = 0;
            while (s < this.sentenceLength - span) {
                int e = s + span;
                this.cells[s][e] = new ViterbiCell(s, e);
                Hashtable<CfgFrame, double[]> cellTable = this.constsProbTable[s][e];
                for (Map.Entry<CfgFrame, double[]> frameProb : cellTable.entrySet()) {
                    CfgFrame gFrame = frameProb.getKey();
                    double gScore = frameProb.getValue()[0];
                    double maxCombScore = 0.0;
                    ViterbiCell.FrameProbSplit leftSplit = null;
                    ViterbiCell.FrameProbSplit rightSplit = null;
                    if (span > 0) {
                        maxCombScore = minusInf;
                        int split = s;
                        while (split < e) {
                            double sumScore;
                            ViterbiCell.FrameProbSplit fpsR;
                            ViterbiCell cellR;
                            ViterbiCell.FrameProbSplit fpsL;
                            ViterbiCell cellL = this.cells[s][split];
                            if (cellL != null && (fpsL = cellL.getMaxFrameProbSplit(gFrame.leftNodeLabel)) != null && (cellR = this.cells[split + 1][e]) != null && (fpsR = cellR.getMaxFrameProbSplit(gFrame.rightNodeLabel)) != null && (sumScore = fpsL.prob + fpsR.prob) > maxCombScore) {
                                maxCombScore = sumScore;
                                leftSplit = fpsL;
                                rightSplit = fpsR;
                            }
                            ++split;
                        }
                    }
                    this.cells[s][e].addFrameProbSplit(gFrame, maxCombScore += gScore, leftSplit, rightSplit);
                }
                ++s;
            }
            ++span;
        }
        ViterbiCell topCell = this.cells[0][this.sentenceLength - 1];
        ViterbiCell.FrameProbSplit topSplit = topCell.getMaxFrameProbSplit();
        TSNodeLabel result = this.getTree(topSplit);
        result.unbinarizeEarly(dotBinarizationMarker);
        result.uncompressUnaryProductions(unaryProductionSeparator);
        ArrayList<TSNodeLabel> terms = result.collectTerminalItems();
        int i = 0;
        for (TSNodeLabel t : terms) {
            TSNodeLabel lexNode = new TSNodeLabel(this.lexicalItems[i], true);
            t.daughters = new TSNodeLabel[]{lexNode};
            lexNode.parent = t;
            ++i;
        }
        return result;
    }

    private void convertCellTableToLog() {
        int i = 0;
        while (i < this.sentenceLength) {
            int j = i;
            while (j < this.sentenceLength) {
                for (Map.Entry<CfgFrame, double[]> e : this.constsProbTable[i][j].entrySet()) {
                    double[] val = e.getValue();
                    double logProb = val[0];
                    double d = val[0] = logProb == 0.0 ? 0.0 : Math.log(logProb);
                }
                ++j;
            }
            ++i;
        }
    }

    public void printBestCellLabels() {
        int i = 0;
        while (i < this.sentenceLength) {
            int j = 0;
            while (j < this.sentenceLength) {
                if (j < i) {
                    System.out.print("\t");
                } else {
                    System.out.print(String.valueOf(this.cells[i][j] == null ? "null" : this.cells[i][j].toString()) + "\t");
                }
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    private TSNodeLabel getTree(ViterbiCell.FrameProbSplit topSplit) {
        TSNodeLabel result = new TSNodeLabel(topSplit.frame.parentNodeLabel, false);
        if (topSplit.cellsSplit[0] == null) {
            return result;
        }
        TSNodeLabel[] daughtersArray = new TSNodeLabel[2];
        result.daughters = daughtersArray;
        int i = 0;
        ViterbiCell.FrameProbSplit[] frameProbSplitArray = topSplit.cellsSplit;
        int n = topSplit.cellsSplit.length;
        int n2 = 0;
        while (n2 < n) {
            ViterbiCell.FrameProbSplit c = frameProbSplitArray[n2];
            TSNodeLabel d = this.getTree(c);
            d.parent = result;
            daughtersArray[i] = d;
            ++i;
            ++n2;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        TSNodeLabel parse1 = new TSNodeLabel("(TOP (A (D a)) (B (E b) (F c)) (C (G d)))");
        TSNodeLabel parse2 = new TSNodeLabel("(TOP (A (D a)) (B (E b) (F c)) (C (H d)))");
        TSNodeLabel parse3 = new TSNodeLabel("(TOP (A (H a)) (B (E b) (F c)) (C (G d)))");
        String[] words = parse1.collectTerminalStrings().toArray(new String[0]);
        MRuleProductMergeUnary mrp = new MRuleProductMergeUnary();
        mrp.prepareNextSentence(words);
        mrp.addNewDerivation(parse1, 0.3);
        mrp.addNewDerivation(parse2, 0.3);
        mrp.addNewDerivation(parse3, 0.3);
        TSNodeLabel bestTree = mrp.getBestTree();
        System.out.println(bestTree);
    }

    public static class CfgFrame {
        Label parentNodeLabel;
        Label leftNodeLabel;
        Label rightNodeLabel;
        int hashCode;

        public CfgFrame(Label p, Label l, Label r) {
            this.parentNodeLabel = p;
            this.leftNodeLabel = l;
            this.rightNodeLabel = r;
        }

        public int hashCode() {
            return new String(this.parentNodeLabel + " " + this.leftNodeLabel + " " + this.rightNodeLabel).hashCode();
        }

        public String toString() {
            return "[" + this.parentNodeLabel + " " + this.leftNodeLabel + " " + this.rightNodeLabel + "]";
        }

        public boolean equals(Object o) {
            if (o instanceof CfgFrame) {
                CfgFrame otherElement = (CfgFrame)o;
                return otherElement.parentNodeLabel == this.parentNodeLabel && otherElement.leftNodeLabel == this.leftNodeLabel && otherElement.rightNodeLabel == this.rightNodeLabel;
            }
            return false;
        }
    }

    public class ViterbiCell {
        protected ArrayList<FrameProbSplit> frameProbSplitArray;
        public int startIndex;
        public int endIndex;

        public ViterbiCell(int s, int e) {
            this.startIndex = s;
            this.endIndex = e;
            this.frameProbSplitArray = new ArrayList();
        }

        public FrameProbSplit getMaxFrameProbSplit() {
            if (this.frameProbSplitArray.isEmpty()) {
                return null;
            }
            double maxProb = minusInf;
            FrameProbSplit result = null;
            for (FrameProbSplit fps : this.frameProbSplitArray) {
                double prob = fps.prob;
                if (!(prob > maxProb)) continue;
                maxProb = prob;
                result = fps;
            }
            return result;
        }

        public FrameProbSplit getMaxFrameProbSplit(Label parentLabel) {
            if (this.frameProbSplitArray.isEmpty()) {
                return null;
            }
            double maxProb = minusInf;
            FrameProbSplit result = null;
            for (FrameProbSplit fps : this.frameProbSplitArray) {
                double prob;
                if (fps.frame.parentNodeLabel != parentLabel || !((prob = fps.prob) > maxProb)) continue;
                maxProb = prob;
                result = fps;
            }
            return result;
        }

        public void addFrameProbSplit(CfgFrame f, double s, FrameProbSplit ls, FrameProbSplit rs) {
            FrameProbSplit fps = new FrameProbSplit(f, s, new FrameProbSplit[]{ls, rs});
            this.frameProbSplitArray.add(fps);
        }

        public String toString() {
            return "(" + this.startIndex + "," + this.endIndex + "," + this.frameProbSplitArray + ")";
        }

        public class FrameProbSplit {
            CfgFrame frame;
            double prob;
            FrameProbSplit[] cellsSplit;

            public FrameProbSplit(CfgFrame frame, double prob, FrameProbSplit[] cellsSplit) {
                this.frame = frame;
                this.prob = prob;
                this.cellsSplit = cellsSplit;
            }

            public int startIndex() {
                return ViterbiCell.this.startIndex;
            }

            public int endIndex() {
                return ViterbiCell.this.endIndex;
            }

            public String toString() {
                FrameProbSplit ls = this.cellsSplit[0];
                String leftId = ls == null ? "null" : "(" + ls.startIndex() + ls.endIndex() + ")";
                FrameProbSplit rs = this.cellsSplit[1];
                String rightId = rs == null ? "null" : "(" + rs.startIndex() + rs.endIndex() + ")";
                return "{" + this.frame + "," + this.prob + "," + leftId + "," + rightId + "}";
            }
        }
    }
}

