# Can Factual Statements be Deceptive? The DefaBel Corpus of Belief-based Deception
This zip file includes the annotated deceptopm corpus discussed in the paper "Can Factual Statements be Deceptive? The DefaBel Corpus of Belief-based Deception by Aswathy Velutharambath, Amelie Wuehrl and Roman
Klinger", accepted at LREC-COLING 2024.

Please cite this paper as:

```
@InProceedings{velutharambath_wuehrl_klinger_2024,
  author    = {Velutharambath, Aswathy and Wuehrl, Amelie  and  Klinger, Roman},
  title     = {Can Factual Statements be Deceptive? The DefaBel Corpus of Belief-based Deception},
  booktitle      = {Proceedings of The Joint International Conference on Computational Linguistics, Language Resources and Evaluation (LREC-COLING)},
  month          = {May},
  year           = {2024},
  address        = {Torino, Italy},
  publisher      = {European Language Resources Association}
}
```

# Content
This zip file contains the following files:

* `README.md`: this file
* `defabel.csv` - the annotated corpus along with the supplementary materials used for the data collection.
* `participant_demographic.csv`- demographic details of the participants who took part in the survey with anonymized ids. 


# Corpus Data
`defabel.csv` contains 1031 annotated German texts (`arguments`) collected via the crowd-sourcing experiment mentioned in the paper. 

* `instance_id`: Index or identifier for each entry in the dataset.
* `participant_id`: ID for participants from the Prolific platform hashed for anonymization.
* `qid`: ID for specific questions in a survey.
* `statement`: The original statement based on which the beliefs were collected
* `instruction`: Instruction given to the participants to generate argumentative text.
* `arguments`: The arguments written by each participant.
* `topic_familiarity`: Participant's familiarity with the topic, on a scale of {1-4}.
* `author_confidence`: Author's confidence in the persuasiveness of the arguments, on a scale of {1-5}.
* `author_belief`: Author's belief regarding the statement, on a scale of {1-5}.
* `is_factual`: Indicates if the statement is factual (yes/no).
* `is_deception`: Indicates if the statement involves deception (true/false).

# License
The annotations in this dataset are licensed under a CC BY-SA license: https://creativecommons.org/licenses/by-sa/4.0/
