/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.lmdbjni;

import java.util.concurrent.atomic.AtomicInteger;
import org.fusesource.hawtjni.runtime.PointerMath;
import org.fusesource.lmdbjni.JNI;
import org.fusesource.lmdbjni.NativeObject;
import org.fusesource.lmdbjni.Unsafe;

class NativeBuffer
extends NativeObject {
    private final Allocation allocation;
    private final long capacity;
    private static final ThreadLocal<Pool> CURRENT_POOL = new ThreadLocal();

    public static NativeBuffer create(long capacity) {
        Pool pool = CURRENT_POOL.get();
        if (pool == null) {
            Allocation allocation = new Allocation(capacity);
            return new NativeBuffer(allocation, allocation.self, capacity);
        }
        return pool.create(capacity);
    }

    public static void pushMemoryPool(int size) {
        Pool original = CURRENT_POOL.get();
        Pool next = new Pool(size, original);
        CURRENT_POOL.set(next);
    }

    public static void popMemoryPool() {
        Pool next = CURRENT_POOL.get();
        next.delete();
        if (next.prev == null) {
            CURRENT_POOL.remove();
        } else {
            CURRENT_POOL.set(next.prev);
        }
    }

    public static NativeBuffer create(byte[] data) {
        if (data == null) {
            return null;
        }
        return NativeBuffer.create(data, 0, data.length);
    }

    public static NativeBuffer create(byte[] data, int offset, int length) {
        NativeBuffer rc = NativeBuffer.create(length);
        rc.write(0L, data, offset, length);
        return rc;
    }

    public static NativeBuffer create(long pointer, int length) {
        return new NativeBuffer(null, pointer, length);
    }

    private NativeBuffer(Allocation allocation, long self, long capacity) {
        super(self);
        this.capacity = capacity;
        this.allocation = allocation;
        if (allocation != null) {
            allocation.retain();
        }
    }

    public void delete() {
        this.allocation.release();
    }

    public long capacity() {
        return this.capacity;
    }

    public void write(long at, byte[] source, int offset, int length) {
        this.checkAllocated();
        if (length < 0) {
            throw new IllegalArgumentException("length cannot be negative");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset cannot be negative");
        }
        if (at < 0L) {
            throw new IllegalArgumentException("at cannot be negative");
        }
        if (at + (long)length > this.capacity) {
            throw new ArrayIndexOutOfBoundsException("at + length exceeds the capacity of this object");
        }
        if (offset + length > source.length) {
            throw new ArrayIndexOutOfBoundsException("offset + length exceed the length of the source buffer");
        }
        if (Unsafe.UNSAFE != null) {
            Unsafe.UNSAFE.copyMemory(source, Unsafe.ARRAY_BASE_OFFSET, null, this.self + at, length);
        } else {
            JNI.buffer_copy(source, (long)offset, this.self, at, (long)length);
        }
    }

    public void read(long at, byte[] target, int offset, int length) {
        this.checkAllocated();
        if (length < 0) {
            throw new IllegalArgumentException("length cannot be negative");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset cannot be negative");
        }
        if (at < 0L) {
            throw new IllegalArgumentException("at cannot be negative");
        }
        if (at + (long)length > this.capacity) {
            throw new ArrayIndexOutOfBoundsException("at + length exceeds the capacity of this object");
        }
        if (offset + length > target.length) {
            throw new ArrayIndexOutOfBoundsException("offset + length exceed the length of the target buffer");
        }
        if (Unsafe.UNSAFE != null) {
            Unsafe.UNSAFE.copyMemory(null, this.self + at, target, Unsafe.ARRAY_BASE_OFFSET, length);
        } else {
            JNI.buffer_copy(this.self, at, target, (long)offset, (long)length);
        }
    }

    public byte[] toByteArray() {
        if (this.capacity > Integer.MAX_VALUE) {
            throw new OutOfMemoryError("Native buffer larger than the largest allowed Java byte[]");
        }
        byte[] rc = new byte[(int)this.capacity];
        this.read(0L, rc, 0, rc.length);
        return rc;
    }

    static class Pool {
        private final Pool prev;
        Allocation allocation;
        long pos;
        long remaining;
        int chunk;

        public Pool(int chunk, Pool prev) {
            this.chunk = chunk;
            this.prev = prev;
        }

        NativeBuffer create(long size) {
            if (size >= (long)this.chunk) {
                Allocation allocation = new Allocation(size);
                return new NativeBuffer(allocation, allocation.self, size);
            }
            if (this.remaining < size) {
                this.delete();
            }
            if (this.allocation == null) {
                this.allocate();
            }
            NativeBuffer rc = new NativeBuffer(this.allocation, this.pos, size);
            this.pos = PointerMath.add(this.pos, size);
            this.remaining -= size;
            return rc;
        }

        private void allocate() {
            this.allocation = new Allocation(this.chunk);
            this.allocation.retain();
            this.remaining = this.chunk;
            this.pos = this.allocation.self;
        }

        public void delete() {
            if (this.allocation != null) {
                this.allocation.release();
                this.allocation = null;
            }
        }
    }

    private static class Allocation
    extends NativeObject {
        private final AtomicInteger retained = new AtomicInteger(0);

        private Allocation(long size) {
            super(JNI.malloc(size));
        }

        void retain() {
            this.checkAllocated();
            this.retained.incrementAndGet();
        }

        void release() {
            this.checkAllocated();
            int r = this.retained.decrementAndGet();
            if (r < 0) {
                throw new Error("The object has already been deleted.");
            }
            if (r == 0) {
                JNI.free(this.self);
                this.self = 0L;
            }
        }
    }
}

