theory question_61_3

imports Main

begin

typedecl entity

consts
  Sun :: "entity ⇒ bool"
  CelestialBody :: "entity ⇒ bool"
  LargestBodyInSolarSystem :: "entity ⇒ bool"
  LargestCelestialBodyInSolarSystem :: "entity ⇒ bool"

(* Explanation 1: The sun is a celestial body and the largest in our solar system. *)
axiomatization where
  explanation_1: "∃x. Sun x ∧ CelestialBody x ∧ LargestBodyInSolarSystem x"

(* Explanation 2: The largest celestial body in our solar system is the Sun. *)
axiomatization where
  explanation_2: "∃x. LargestCelestialBodyInSolarSystem x ∧ Sun x"

theorem hypothesis:
  assumes asm: "LargestBodyInSolarSystem x"
  (* Hypothesis: The largest body in our solar system is the Sun. *)
  shows "Sun x"
proof -
  from asm have "LargestBodyInSolarSystem x" by simp
  then obtain y where y: "LargestCelestialBodyInSolarSystem y" and "Sun y" using explanation_2 by blast
  then have "x = y" using explanation_1 by blast
  then show ?thesis using y by simp
qed

end
