theory question_81_8
imports Main

begin

typedecl entity
typedecl event

consts
  ExternalMigration :: "entity ⇒ bool"
  Entity :: "entity ⇒ bool"
  PopulationSize :: "entity ⇒ entity"
  Cause :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  SuddenReduction :: "event ⇒ bool"
  Occur :: "event ⇒ bool"
  BottleneckEffect :: "event ⇒ bool"
  DueTo :: "event ⇒ event ⇒ bool"

(* Explanation 1: External migration can cause a sudden reduction in the population size of a specific entity. *)
axiomatization where
  explanation_1: "∀x y e1 e2. ExternalMigration x ∧ Entity y ∧ PopulationSize y ≠ 0 ⟶ (∃e1. Cause e1 ∧ Agent e1 x ∧ Patient e1 e2) ∧ (∃e2. SuddenReduction e2 ∧ Occur e2 ∧ Agent e2 y ∧ Patient e2 (PopulationSize y))"

(* Explanation 2: If a sudden reduction in the population size of a specific entity occurs, then the bottleneck effect occurs in that entity due to the reduction. *)
axiomatization where
  explanation_2: "∀x y e1 e2. Entity x ∧ PopulationSize y ≠ 0 ∧ SuddenReduction e1 ∧ Occur e1 ∧ Agent e1 y ∧ Patient e1 (PopulationSize x) ⟶ (∃e2. BottleneckEffect e2 ∧ Occur e2 ∧ Agent e2 x ∧ DueTo e2 e1)"

theorem hypothesis:
  assumes asm: "ExternalMigration x"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃e. BottleneckEffect e ∧ Occur e ∧ Agent e x"
proof -
  have "ExternalMigration x" by fact
  then obtain e1 e2 where e1: "Cause e1 ∧ Agent e1 x ∧ Patient e1 e2"
                         and e2: "SuddenReduction e2 ∧ Occur e2 ∧ Agent e2 y ∧ Patient e2 (PopulationSize y)"
                         for y using explanation_1 by blast
  then have "Entity y" "PopulationSize y ≠ 0" by auto
  then obtain e3 where e3: "BottleneckEffect e3 ∧ Occur e3 ∧ Agent e3 y ∧ DueTo e3 e2"
                         using explanation_2 by blast
  then have "BottleneckEffect e3" "Occur e3" "Agent e3 x" using e1 e2 e3 by auto
  then show ?thesis using e3 by blast
qed

end
