theory question_85_0

imports Main

begin

typedecl entity
typedecl event

consts
  PressureReceptors :: "entity ⇒ bool"
  Skin :: "entity ⇒ bool"
  Location :: "event ⇒ entity ⇒ bool"
  PacinianCorpuscles :: "entity ⇒ bool"
  Identity :: "event ⇒ bool"

(* Explanation 1: Pressure receptors are found mainly in the skin. *)
axiomatization where
  explanation_1: "∀x y. PressureReceptors x ∧ Skin y ∧ Location x y"

(* Explanation 2: Pacinian corpuscles are pressure receptors. *)
axiomatization where
  explanation_2: "∀x. PacinianCorpuscles x ∧ PressureReceptors x ∧ Identity x"

theorem hypothesis:
  assumes asm: "PacinianCorpuscles x ∧ Skin y ∧ Location x y"
  (* Hypothesis: Pacinian corpuscles are found mainly in the skin. *)
  shows "∃x y z e. PressureReceptors x ∧ Skin y ∧ Location x y ∧ Identity z ∧ PacinianCorpuscles z"
proof -
  from asm have "PacinianCorpuscles x ∧ Skin y ∧ Location x y" by simp
  then obtain e1 where e1: "PressureReceptors x ∧ Skin y ∧ Location x y" using explanation_1 by blast
  then have "PressureReceptors z ∧ Identity z ∧ PacinianCorpuscles z" using explanation_2 by blast
  have conclusion: "PressureReceptors x ∧ Skin y ∧ Location x y ∧ Identity z ∧ PacinianCorpuscles z" using e1, asm by simp
  show ?thesis using conclusion by blast
qed

end
