theory question_93_1

imports Main

begin

typedecl entity
typedecl event

consts
 LivingAnimals :: "entity ⇒ bool"
 Woman :: "entity ⇒ bool"
 Broom :: "entity ⇒ bool"
 Holding :: "event ⇒ bool"
 Agent :: "event ⇒ entity ⇒ bool"
 Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: There are living animals. *)
axiomatization where
 explanation_1: "∀x. LivingAnimals x"

(* Explanation 2: The woman is holding a broom. *)
axiomatization where
 explanation_2: "∃x y e. Woman x ∧ Broom y ∧ Holding e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
 (* Premise: Old woman chasing away two lambs with a broom. *)
 assumes asm: "OldWoman x  ∧ Lambs y  ∧ Broom z  ∧ Chasing e1  ∧ Holding e2  ∧ Agent e1  x  ∧ Agent e2  x  ∧ Patient e1  y  ∧ Patient e2  z "
 (* Hypothesis: There is a woman and some animals. *)
 shows "∃x y. Woman x  ∧ Animals y "
proof -
 from asm have "OldWoman x" by blast
 then have "Woman x" using explanation_1 by blast
 then have "LivingAnimals y" using explanation_2 by blast
 then show ?thesis using `Woman x` `LivingAnimals y` by blast
qed

end
