theory question_50_4

imports Main

begin

typedecl entity
typedecl event
consts
  Man :: "entity ⇒ bool"
  DirtBike :: "entity ⇒ bool"
  Riding :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Racetrack :: "entity ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A man is riding a dirt bike. *)
axiomatization where
  explanation_1: "∃x e. Man x ∧ DirtBike e ∧ Riding e ∧ Agent e x"

theorem hypothesis:
  (* Premise: A man riding a dirt bike on a racetrack. *)
  assumes asm: "Man x ∧ DirtBike y ∧ Racetrack e ∧ Riding e ∧ Agent e x ∧ On e y"
  (* Hypothesis: A man is riding a dirt bike. *)
  shows "∃x e. Man x ∧ DirtBike e ∧ Riding e ∧ Agent e x"
proof -
  from asm have "Man x" by blast
  from this have "DirtBike e" using explanation_1 by blast
  from asm have "Riding e" by blast
  from this have "Agent e x" using explanation_1 by blast
  from asm have "On e y" by blast
  show ?thesis using `Man x` `DirtBike e` `Riding e` `Agent e x` `On e y` by blast
qed

end
