theory question_65_5
imports Main
begin

typedecl entity
typedecl event

consts
  Electricity :: "entity ⇒ bool"
  LightBulb :: "entity ⇒ bool"
  Flows :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  TurnOn :: "event ⇒ bool"
  ComesOn :: "event ⇒ bool"
  Switch :: "entity ⇒ bool"
  SimpleSeriesCircuit :: "entity ⇒ bool"
  Includes :: "event ⇒ bool"
  Closed :: "event ⇒ bool"
  StartsFlowing :: "event ⇒ bool"

(* Explanation 1: When electricity flows to a light bulb, the light bulb will turn on; come on. *)
axiomatization where
  explanation_1: "∀x y e1 e2 e3. Electricity x ∧ LightBulb y ∧ Flows e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ (TurnOn e2 ∧ Agent e2 y ∧ ComesOn e3 ∧ Agent e3 y)"

(* Explanation 2: When a switch in a simple series circuit that includes a light bulb is closed, electricity starts flowing. The electricity flows to the light bulb in the circuit. *)
axiomatization where
  explanation_2: "∀x y z e1 e2 e3 e4. Switch x ∧ SimpleSeriesCircuit y ∧ LightBulb z ∧ Includes e1 ∧ Agent e1 y ∧ Patient e1 z ∧ Closed e2 ∧ Agent e2 x ⟶ (StartsFlowing e3 ∧ Agent e3 x ∧ Flows e4 ∧ Agent e4 x ∧ Patient e4 z)"  

theorem hypothesis:
  (* Premise: when the switch in a simple series circuit is closed *)
  assumes asm: "Switch x ∧ SimpleSeriesCircuit y ∧ Closed e ∧ Agent e x"
  (* Hypothesis: When electricity is flowing to the light bulb, the light comes on. *)
  shows "∃x y e1 e2. Electricity x ∧ LightBulb y ∧ Flows e1 ∧ Agent e1 x ∧ Patient e1 y ∧ ComesOn e2 ∧ Agent e2 y"
proof -
  from asm obtain z e1 e2 where e1: "SimpleSeriesCircuit y ∧ LightBulb z ∧ Includes e1 ∧ Agent e1 y ∧ Patient e1 z ∧ StartsFlowing e2 ∧ Agent e2 x" using explanation_2 by blast
  then obtain e3 where e3: "Electricity x ∧ Flows e3 ∧ Agent e3 x ∧ Patient e3 z" using explanation_2 by blast
  then obtain e4 e5 where e4: "TurnOn e4 ∧ Agent e4 z ∧ ComesOn e5 ∧ Agent e5 z" using explanation_1 by blast
  show ?thesis using asm e1 e3 e4 by blast
qed

end
