theory question_66_1

imports Main

begin
typedecl entity
typedecl event

consts
  Bartender :: "entity ⇒ bool"
  Person :: "entity ⇒ bool"
  BlackAttire :: "entity ⇒ bool"
  Male :: "entity ⇒ bool"
  SleevesRolledUp :: "entity ⇒ bool"
  ElbowHeight :: "entity ⇒ bool"
  MakingDrink :: "event ⇒ bool"
  InMartiniGlass :: "event ⇒ bool"

(* Explanation 1: A bartender, being a person, is dressed in black. *)
axiomatization where
  explanation_1: "∀x. Bartender x ⟶ Person x ∧ BlackAttire x"

(* Explanation 2: A person dressed in black can be a bartender. *)
axiomatization where
  explanation_2: "∃x. Person x ∧ BlackAttire x ⟶ Bartender x"

(* Explanation 3: Bartenders, as persons, can wear black attire. *)
axiomatization where
  explanation_3: "∀x. Bartender x ⟶ Person x ∧ BlackAttire x"

theorem hypothesis:
  (* Premise: A male bartender dressed in all black with his sleeves rolled up to elbow height making a drink in a martini glass. *)
  assumes asm: "Male x ∧ Bartender x ∧ BlackAttire x ∧ SleevesRolledUp x ∧ ElbowHeight x ∧ MakingDrink e ∧ InMartiniGlass e"
  (* Hypothesis: A person in black *)
  shows "∃x. Person x ∧ BlackAttire x"
proof -
  from asm have "Person x ∧ BlackAttire x" using explanation_1 by blast
  then show ?thesis by blast
qed

end
