theory question_64_1
imports Main

begin
typedecl entity
typedecl event

consts
  FoodVendor :: "entity ⇒ bool"
  Food :: "entity ⇒ bool"
  Serve :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Lead :: "event ⇒ bool"
  StandInLineForFood :: "entity"
  People :: "entity ⇒ bool"
  Waiting :: "event ⇒ bool"
  StandInLine :: "event ⇒ bool"

(* Explanation 1: A food vendor serves food, leading people to stand in line for food. *)
axiomatization where
  explanation_1: "∀x y e1 e2. FoodVendor x ∧ Food y ∧ Serve e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Lead e2 ∧ Agent e2 x ∧ Patient e2 StandInLineForFood"

theorem hypothesis:
  (* Premise: People are waiting in line by a food vendor. *)
  assumes asm: "People x ∧ FoodVendor y ∧ Waiting e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: People stand in line for food. *)
  shows "∃x y e. People x ∧ Food y ∧ StandInLine e ∧ For e y"
proof -
  from asm have "People x ∧ FoodVendor y ∧ Waiting e ∧ Agent e x ∧ Patient e y" by blast
  then have "Food y ∧ Serve e1 ∧ Agent e1 y ∧ Patient e1 StandInLineForFood ∧ Lead e2 ∧ Agent e2 y ∧ Patient e2 StandInLineForFood" using explanation_1 by blast
  then have "People x ∧ Food y ∧ StandInLine e ∧ For e StandInLineForFood" by blast
  then show ?thesis using `People x` `Food y` by blast
qed

end
