theory question_51_0

imports Main

begin
typedecl entity
typedecl event

consts
  Speech :: "event ⇒ bool"
  Gives :: "event ⇒ bool"
  Speaking :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Man :: "entity ⇒ bool"
  PublicSpeaking :: "event ⇒ bool"
  At :: "event ⇒ entity ⇒ entity ⇒ bool"
  CostumeParty :: "entity"
  Ornate :: "entity"

(* Explanation 1: If someone gives a speech that means that they are speaking. *)
axiomatization where
  explanation_1: "∀x e1 e2. Speech e1 ∧ Gives e2 ∧ Agent e2 x ⟶ Speaking e1 ∧ Agent e1 x"

theorem hypothesis:
  (* Premise: A man gives a speech at an ornate costume party. *)
  assumes asm: "Man x ∧ Speech e ∧ Gives e ∧ Agent e x ∧ At e CostumeParty Ornate"
  (* Hypothesis: A man is public speaking. *)
  shows "∃x e. Man x ∧ PublicSpeaking e ∧ Agent e x"
proof -
  from asm have "Man x ∧ Speech e ∧ Gives e ∧ Agent e x" by blast
  then have "Speaking e ∧ Agent e x" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
