'''
input: formula strings
output: the answer of the mathematical formula
'''
import os
import re
from operator import pow, truediv, mul, add, sub
import wolframalpha
query = '1+2*3'

def calculator(query: str):
    operators = {
        '+': add,
        '-': sub,
        '*': mul,
        '/': truediv,
    }
    query = re.sub(r'\s+', '', query)
    if query.isdigit():
        return float(query)
    for c in operators.keys():
        left, operator, right = query.partition(c)
        if operator in operators:
            return round(operators[operator](calculator(left), calculator(right)),2)

def WolframAlphaCalculator(input_query: str):
    try:
        wolfram_alpha_appid = "<YOUR_WOLFRAMALPHA_APP_ID>"
        wolfram_client = wolframalpha.Client(wolfram_alpha_appid)
        res = wolfram_client.query(input_query)
        assumption = next(res.pods).text
        answer = next(res.results).text
    except:
        raise Exception("Invalid input query for Calculator. Please check the input query or use other functions to do the computation.")
    # return f"Assumption: {assumption} \nAnswer: {answer}"
    return answer

if __name__ == "__main__":
    query = 'max(37.97,76.1)'
    print(WolframAlphaCalculator(query))