import argparse

# training configurations
parser = argparse.ArgumentParser(description="configs for training biencoder and crossencoder")
parser.add_argument("--max_context_length", default=128, type=int)
parser.add_argument("--max_cand_length", default=128, type=int)
parser.add_argument("--bert_model", default="bert-base-uncased", type=str)
parser.add_argument("--lowercase", action="store_false", help="Whether to lower case the input text. True for uncased models, False for cased models.")
parser.add_argument("--data_path", default="dataset", type=str, help="The path to the train data.")
parser.add_argument("--output_path",default="saved_models", type=str, help="The output directory where generated output file (model, etc.) is to be dumped.")

parser.add_argument("--train_batch_size", default=16, type=int, help="Total batch size for training.")
parser.add_argument("--cands_num", default=16, type=int, help="number of candidates for a mention.")
parser.add_argument("--layer_id", default=0, type=int, help="the outputs of layer for turbulence.")
parser.add_argument("--eval_batch_size", default=8, type=int, help="Total batch size for evaluating.")
parser.add_argument("--eval_interval", default=100, type=int, help="Total batch size for evaluating.")
parser.add_argument("--max_grad_norm", default=1.0, type=float)
parser.add_argument("--learning_rate", default=1e-5, type=float, help="The initial learning rate for Adam.")
parser.add_argument("--epsilon", default=1.0, type=float, help="Step length for the A.")
parser.add_argument("--num_train_epochs", default=5, type=int, help="Number of training epochs.")
parser.add_argument("--print_interval", type=int, default=10, help="Interval of loss printing")
parser.add_argument("--warmup_proportion", default=0.1, type=float, help="Proportion of training to perform linear learning rate warmup for. ""E.g., 0.1 = 10% of training.")
parser.add_argument("--shuffle", type=bool, default=False, help="Whether to shuffle train data")
parser.add_argument("--do_adv_loss", type=bool, default=True, help="Whether to shuffle train data")

args = parser.parse_args()
