# -*- coding: utf-8 -*-
import numpy as np
import matplotlib.pyplot as plt
import json
import seaborn as sns
import pandas as pd

sns.set_theme(style="whitegrid")
with open("./lt/ut_grad_norm.json") as json_file:
    ut = json.load(json_file)
with open("./lt_grad_norm.json") as json_file:
    lt = json.load(json_file)
fig, ax = plt.subplots()

data = pd.DataFrame(
    np.transpose([np.array(ut)[:, 2],
     np.array(lt)[:len(np.array(ut)[:, 0]), 2]]),
    np.array(ut)[:, 1],
    columns=["UT", "LT"])
ax = sns.relplot(data=data, palette="tab10", kind='line',linewidth=2.5)
ax.set(ylabel='grad_norm', xlabel='iteration')
plt.show()