import random, os, numpy, scipy
from codecs import open


def createHTML(texts, weights, revealed_list, prediction_list,
               target_list, conf_list, original, fileName):
    """
    Creates a html file with text heat.
	weights: attention weights for visualizing
	texts: text on which attention weights are to be visualized
    """
    fileName = os.getcwd()+'/' + fileName
    fOut = open(fileName, "w+", encoding="utf-8")
    part1 = """
    <html lang="en">
    <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <style>
    body {
    font-family: Sans-Serif;
    }
    </style>
    </head>
    <body>
    <h3>
    Attention Heatmaps
    </h3>
    </body>
    <script>
    """
    part2 = """
    var color = "255,0,0";
    var ngram_length = 3;
    var half_ngram = 1;
    
    
    var display_words = "<p><b>Original Sentence: </b>";
    for (var iter=0; iter < original_text.length; iter++) {
        if (iter == original_text.length-1){
        display_words += " " + "<b><span style='color:green'>" + original_text[iter] +"</span>"+ "</b></br>";}
        else{
        display_words += " " + original_text[iter];}
    }
    
    for (var k=0; k < any_text.length; k++) {
    var tokens = any_text[k].split(" ");
    var intensity = new Array(tokens.length);
    var max_intensity = Number.MIN_SAFE_INTEGER;
    var min_intensity = Number.MAX_SAFE_INTEGER;
    for (var i = 0; i < intensity.length; i++) {
    intensity[i] = 0.0;
    for (var j = -half_ngram; j < ngram_length-half_ngram; j++) {
    if (i+j < intensity.length && i+j > -1) {
    intensity[i] += trigram_weights[k][i + j];
    }
    }
    if (i == 0 || i == intensity.length-1) {
    intensity[i] /= 2.0;
    } else {
    intensity[i] /= 3.0;
    }
    if (intensity[i] > max_intensity) {
    max_intensity = intensity[i];
    }
    if (intensity[i] < min_intensity) {
    min_intensity = intensity[i];
    }
    }
    var denominator = max_intensity - min_intensity;
    for (var i = 0; i < intensity.length; i++) {
    intensity[i] = (intensity[i] - min_intensity) / denominator;
    }
    
    var heat_text = "";
    if (k==0){
    heat_text += display_words + "</br>" + "<b>(Revealed </b>" + revealed_strings[k] + ") : ";
    }
    else{
    var heat_text = "<b>(Revealed </b>";
    
    if (k==4){
    heat_text +=  revealed_strings[k] + ".0) : ";
    }
    else{
    heat_text +=  revealed_strings[k] + ") : ";
    }
    }
    var space = "";
    for (var i = 0; i < tokens.length; i++) {
    heat_text += "<span style='background-color:rgba(" + color + "," + intensity[i] + ")'>" + space + tokens[i] + "  " +"</span>";
    if (space == "") {
    space = " ";
    }
    }
    
    if(targets[k] == predictions[k]){
    heat_text += "-->" + "<b><span style='color:green'>" + predictions[k] +"</span>"+ "</b>";
    }
    if(targets[k] != predictions[k]){
    heat_text += "--> " + "<span style='color:red'>" + predictions[k] +"</span>";
    }
    heat_text += " (confidence: " + confidences[k] + ") </br>"
    
    heat_text += "<p>";
    document.body.innerHTML += heat_text;
    }
    display_words+="</p>";
    document.boday.innerHTML += display_words;
    </script>
    </html>"""
    putQuote = lambda x: "\"%s\"" % x
    textsString = "var any_text = [%s];\n" % (",".join(map(putQuote, texts)))
    weightsString = "var trigram_weights = [%s];\n" % (",".join(map(str, weights)))
    revealedString = "var revealed_strings = [%s];\n" % (",".join(map(str, revealed_list)))
    predictionString = "var predictions = [%s];\n" %(",".join(map(putQuote, prediction_list)))
    confidenceString = "var confidences = [%s];\n" % (",".join(map(putQuote, conf_list)))
    targetString = "var targets = [%s];\n" % (",".join(map(putQuote, target_list)))
    OriginalString = "var original_text = [%s];\n" % (",".join(map(putQuote, original)))

    fOut.write(part1)
    fOut.write(textsString)
    fOut.write(weightsString)
    fOut.write(revealedString)
    fOut.write(predictionString)
    fOut.write(confidenceString)
    fOut.write(targetString)
    fOut.write(OriginalString)
    fOut.write(part2)
    fOut.close()

    return