/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser.comparators;

import java.util.Comparator;
import java.util.List;
import simplenlg.features.Category;
import simplenlg.features.DiscourseFunction;
import simplenlg.realiser.HeadedPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.comparators.OrderDefaults;

public class PhraseComparator
implements Comparator<Phrase> {
    protected List<Category> _catOrder;
    protected List<DiscourseFunction> _funcOrder;
    protected List<String> _baseOrder;

    public static PhraseComparator defaultInstance() {
        return new PhraseComparator(OrderDefaults.CATEGORY_ORDER, OrderDefaults.FUNCTION_ORDER, OrderDefaults.BASEFORM_ORDER);
    }

    public PhraseComparator(List<Category> catOrder, List<DiscourseFunction> functionOrder, List<String> baseformOrder) {
        this.setBaseformOrder(baseformOrder);
        this.setCategoryOrder(catOrder);
        this.setFunctionOrder(functionOrder);
    }

    @Override
    public int compare(Phrase p1, Phrase p2) {
        Category c1 = p1.getCategory();
        Category c2 = p2.getCategory();
        DiscourseFunction f1 = p1.getDiscourseFunction();
        DiscourseFunction f2 = p2.getDiscourseFunction();
        int comparison = 0;
        if (c1 != c2 && this._catOrder.contains((Object)c1) && this._catOrder.contains((Object)c2)) {
            comparison = Integer.valueOf(this._catOrder.indexOf((Object)c1)).compareTo(this._catOrder.indexOf((Object)c2));
        } else if (f1 != f2 && this._funcOrder.contains(f1) && this._funcOrder.contains(f2)) {
            comparison = Integer.valueOf(this._funcOrder.indexOf(f1)).compareTo(this._funcOrder.indexOf(f2));
        } else if (p1 instanceof HeadedPhraseSpec && p2 instanceof HeadedPhraseSpec) {
            Object head1 = ((HeadedPhraseSpec)p1).getHead();
            Object head2 = ((HeadedPhraseSpec)p2).getHead();
            if (head1 != null && head2 != null) {
                String base1 = head1.getBaseForm();
                String base2 = head2.getBaseForm();
                if (this._baseOrder.contains(base1) && this._baseOrder.contains(base2)) {
                    comparison = Integer.valueOf(this._baseOrder.indexOf(base1)).compareTo(this._baseOrder.indexOf(base2));
                }
            }
        }
        return comparison;
    }

    public void setCategoryOrder(List<Category> categories) {
        this._catOrder = categories;
    }

    public List<Category> getCategoryOrder() {
        return this._catOrder;
    }

    public List<DiscourseFunction> getFunctionOrder() {
        return this._funcOrder;
    }

    public List<String> getBaseformOrder() {
        return this._baseOrder;
    }

    public void setFunctionOrder(List<DiscourseFunction> functions) {
        this._funcOrder = functions;
    }

    public void setBaseformOrder(List<String> forms) {
        this._baseOrder = forms;
    }
}

