/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import simplenlg.exception.LexiconException;
import simplenlg.features.Case;
import simplenlg.features.Category;
import simplenlg.features.Form;
import simplenlg.features.Gender;
import simplenlg.features.InflectionType;
import simplenlg.features.NumberAgr;
import simplenlg.features.Person;
import simplenlg.features.Tense;
import simplenlg.features.VerbType;
import simplenlg.lexicon.LexicalClass;
import simplenlg.lexicon.Lexicon;
import simplenlg.lexicon.LexiconInterface;
import simplenlg.lexicon.data.Adjectives;
import simplenlg.lexicon.data.Nouns;
import simplenlg.lexicon.data.Verbs;
import simplenlg.lexicon.lexicalitems.Adjective;
import simplenlg.lexicon.lexicalitems.Conjunction;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.lexicon.lexicalitems.Determiner;
import simplenlg.lexicon.lexicalitems.LexicalItem;
import simplenlg.lexicon.lexicalitems.Noun;
import simplenlg.lexicon.lexicalitems.Preposition;
import simplenlg.lexicon.lexicalitems.Pronoun;
import simplenlg.lexicon.lexicalitems.Symbol;
import simplenlg.lexicon.lexicalitems.Verb;
import simplenlg.lexicon.lexicalitems.Word;
import simplenlg.lexicon.morph.MorphologicalRule;
import simplenlg.lexicon.morph.WordLists;
import simplenlg.realiser.AdjPhraseSpec;
import simplenlg.realiser.NPPhraseSpec;
import simplenlg.realiser.PPPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.SPhraseSpec;

public class Lexicon
implements LexiconInterface {
    TreeMap<String, LexicalItem> itemsByID = new TreeMap();
    TreeMap<String, Set<String>> itemsByBaseform = new TreeMap();
    TreeMap<Category, Set<String>> itemsByCategory = new TreeMap();
    TreeMap<String, MorphologicalRule<?>> rules = new TreeMap();
    TreeMap<String, LexicalClass<?>> lexicalClasses = new TreeMap();
    String idPrefix = "I";

    public static LexicalItem makeLexicalItem(Category c, String w) {
        switch (1.$SwitchMap$simplenlg$features$Category[c.ordinal()]) {
            case 1: {
                return new Noun(w);
            }
            case 2: {
                return new Verb(w);
            }
            case 3: {
                return new Pronoun(w);
            }
            case 4: {
                return new Preposition(w);
            }
            case 5: {
                return new Conjunction(w);
            }
            case 6: {
                return new Determiner(w);
            }
            case 7: {
                return new Symbol(w);
            }
        }
        return null;
    }

    @Override
    public void addItem(Category cat, String word) {
        LexicalItem lex = Lexicon.makeLexicalItem(cat, word);
        this.addItem(lex);
    }

    @Override
    public void addItem(LexicalItem lex) {
        String word = lex.getBaseForm();
        String id = lex.getID();
        if (id == null) {
            id = this.makeID();
            lex.setID(id);
        }
        this.itemsByID.put(id, lex);
        if (this.itemsByBaseform.containsKey(word)) {
            this.itemsByBaseform.get(word).add(id);
        } else {
            HashSet<String> ids = new HashSet<String>();
            ids.add(id);
            this.itemsByBaseform.put(word, ids);
        }
        Category cat = lex.getCategory();
        if (this.itemsByCategory.containsKey((Object)cat)) {
            this.itemsByCategory.get((Object)lex.getCategory()).add(id);
        } else {
            HashSet<String> items = new HashSet<String>();
            items.add(id);
            this.itemsByCategory.put(cat, items);
        }
    }

    @Override
    public Collection<LexicalItem> getItems(String base) {
        ArrayList<LexicalItem> items = new ArrayList<LexicalItem>();
        if (this.itemsByBaseform.containsKey(base)) {
            for (String id : this.itemsByBaseform.get(base)) {
                items.add(this.itemsByID.get(id));
            }
        }
        return items;
    }

    @Override
    public LexicalItem getItem(Category cat, String base) {
        if (cat == null || base == null) {
            return null;
        }
        if (this.itemsByBaseform.containsKey(base)) {
            for (String id : this.itemsByBaseform.get(base)) {
                LexicalItem lex = this.itemsByID.get(id);
                if (!lex.getCategory().equals((Object)cat)) continue;
                return lex;
            }
        }
        return null;
    }

    @Override
    public Noun getNoun(String base) {
        return (Noun)this.getItem(Category.NOUN, base);
    }

    public Verb getVerb(String base) {
        return (Verb)this.getItem(Category.VERB, base);
    }

    public Adjective getAdjective(String base) {
        return (Adjective)this.getItem(Category.ADJECTIVE, base);
    }

    @Override
    public Verb getComplexVerb(String base) {
        String mainVerb = base;
        String prefix = "";
        int split = base.lastIndexOf(" ") + 1;
        if (split > 0) {
            mainVerb = base.substring(split);
            prefix = prefix + base.substring(0, split);
        }
        if ((split = base.lastIndexOf("|") + 1) > 0) {
            mainVerb = base.substring(split);
            prefix = prefix + base.substring(0, split - 1);
        }
        Verb verb = this.getVerb(mainVerb);
        Verb cloneVerb = (Verb)verb.clone();
        cloneVerb.setVerbPrefix(prefix);
        return cloneVerb;
    }

    public List<LexicalItem> getItems(Category cat) {
        ArrayList<LexicalItem> items = new ArrayList<LexicalItem>();
        if (this.itemsByCategory.containsKey((Object)cat)) {
            for (String id : this.itemsByCategory.get((Object)cat)) {
                items.add(this.itemsByID.get(id));
            }
        }
        return items;
    }

    @Override
    public LexicalItem getItemByID(String id) {
        return this.itemsByID.get(id);
    }

    @Override
    public boolean hasItem(Category cat, String word) {
        return this.getItem(cat, word) != null;
    }

    @Override
    public boolean hasItem(String word) {
        for (String baseform : this.itemsByBaseform.keySet()) {
            if (!baseform.equalsIgnoreCase(word)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasItemID(String id) {
        return this.itemsByID.containsKey(id);
    }

    @Override
    public int getNumberOfItems() {
        return this.itemsByID.keySet().size();
    }

    @Override
    public int getNumberOfItems(Category cat) {
        if (this.itemsByCategory.containsKey((Object)cat)) {
            return this.itemsByCategory.get((Object)cat).size();
        }
        return 0;
    }

    public int getNumberOfEntries(String baseform) {
        if (this.itemsByBaseform.containsKey(baseform)) {
            return this.itemsByBaseform.get(baseform).size();
        }
        return 0;
    }

    public String getPlural(String word) {
        Noun n = (Noun)this.getItem(Category.NOUN, word);
        if (n == null) {
            n = new Noun(word);
            this.addItem(n);
        }
        return n.getForm(Case.NOMINATIVE, NumberAgr.PLURAL);
    }

    public String getComparative(String word) {
        Adjective a = (Adjective)this.getItem(Category.ADJECTIVE, word);
        if (a == null) {
            a = new Adjective(word);
            this.addItem(a);
        }
        return a.getComparative();
    }

    public String getSuperlative(String word) {
        Adjective a = (Adjective)this.getItem(Category.ADJECTIVE, word);
        if (a == null) {
            a = new Adjective(word);
            this.addItem(a);
        }
        return a.getSuperlative();
    }

    public String getPastParticiple(String word) {
        Verb v = (Verb)this.getItem(Category.VERB, word);
        if (v == null) {
            v = new Verb(word);
            this.addItem(v);
        }
        return v.getPastParticiple();
    }

    public String getPresentParticiple(String word) {
        Verb v = (Verb)this.getItem(Category.VERB, word);
        if (v == null) {
            v = new Verb(word);
            this.addItem(v);
        }
        return v.getPresentParticiple();
    }

    public String getContinuous(String word) {
        return this.getPresentParticiple(word);
    }

    public String getIngForm(String word) {
        return this.getPresentParticiple(word);
    }

    @Override
    public <T extends LexicalItem> void addRule(MorphologicalRule<T> rule) {
        if (!rule.hasName()) {
            throw new LexiconException("Cannot add unnamed morphological rule to the Lexicon.");
        }
        if (this.rules == null) {
            this.rules = new TreeMap();
        }
        this.rules.put(rule.getName(), rule);
    }

    @Override
    public Collection<MorphologicalRule<?>> getRules() {
        return this.rules.values();
    }

    @Override
    public String applyRule(String ruleName, String word) {
        try {
            return this.rules.get(ruleName).apply(word);
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    @Override
    public <T extends LexicalItem> String applyRule(String ruleName, T lex) {
        if (this.rules.containsKey(ruleName)) {
            try {
                return this.rules.get(ruleName).apply(lex);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getVerbForm(String v, Tense t, Person p, NumberAgr n) {
        Verb verb;
        if (this.hasItem(Category.VERB, v)) {
            verb = (Verb)this.getItem(Category.VERB, v);
        } else {
            verb = new Verb(v);
            this.addItem(verb);
        }
        return verb.getForm(p, n, t, Form.NORMAL);
    }

    public String getBeSubjunctive() {
        return "were";
    }

    @Override
    public void reset() {
        this.itemsByBaseform.clear();
        this.itemsByID.clear();
        this.itemsByCategory.clear();
    }

    @Override
    public void addLexicalClass(LexicalClass<?> lexClass) {
        lexClass.setParentLexicon(this);
        this.lexicalClasses.put(lexClass.getID(), lexClass);
    }

    @Override
    public boolean hasLexicalClass(String classID) {
        return this.lexicalClasses.containsKey(classID);
    }

    @Override
    public LexicalClass<?> getLexicalClass(String classID) {
        return this.lexicalClasses.get(classID);
    }

    public NPPhraseSpec makeNP(String noun) {
        Pronoun pro;
        if (noun.indexOf(" ") > -1) {
            String spec = noun.substring(0, noun.indexOf(" "));
            String head = noun.substring(noun.indexOf(" ") + 1);
            if (Constants.getDeterminer(spec) != null || Constants.getPronoun(spec) != null) {
                return this.makeNP(spec, head);
            }
        }
        if ((pro = Constants.getPronoun(noun)) != null) {
            return this.makePronounNP(pro);
        }
        Noun n = this.getNoun(noun);
        if (n != null) {
            return new NPPhraseSpec(n);
        }
        return new NPPhraseSpec(noun);
    }

    public NPPhraseSpec makeNP(Object spec, String noun) {
        NPPhraseSpec np = this.makeNP(noun);
        Word sp = null;
        if (spec instanceof String && (sp = Constants.getDeterminer((String)spec)) == null && (sp = Constants.getPronoun((String)spec)) != null && Constants.requiresPlural((Pronoun)sp)) {
            np.setPlural(true);
        }
        if (sp != null) {
            np.setSpecifier(sp);
        } else {
            np.setSpecifier(spec);
        }
        return np;
    }

    public PPPhraseSpec makePP(Object prep, Object np) {
        Phrase comp;
        Preposition p;
        if (prep instanceof String) {
            p = Constants.getPreposition((String)prep);
        } else if (prep instanceof Preposition) {
            p = (Preposition)prep;
        } else {
            return null;
        }
        if (np instanceof String) {
            comp = this.makeNP((String)np);
        } else if (np instanceof Phrase) {
            comp = (Phrase)np;
        } else {
            return null;
        }
        return new PPPhraseSpec(p, comp);
    }

    public PPPhraseSpec makePP(String prep, Object np, Case c) {
        Preposition p = new Preposition(prep, c);
        return this.makePP(p, np);
    }

    public PPPhraseSpec makePP(String prep, Object np, boolean postpos) {
        Preposition p = Constants.getPostposition(prep);
        return this.makePP(p, np);
    }

    public PPPhraseSpec makePP(Object prep, Object spec, String noun) {
        return this.makePP(prep, this.makeNP(spec, noun));
    }

    public PPPhraseSpec makePP(String prep, Object spec, String noun, Case c) {
        return this.makePP(prep, this.makeNP(spec, noun), c);
    }

    public AdjPhraseSpec makeAdjP(String adj) {
        Adjective a = this.getAdjective(adj);
        if (a == null) {
            return new AdjPhraseSpec(adj);
        }
        return new AdjPhraseSpec(a);
    }

    public SPhraseSpec makeS(Object verb) {
        return this.makeS(new NPPhraseSpec(Constants.PRO_EXPLETIVE), verb);
    }

    public SPhraseSpec makeS(Object subj, Object verb) {
        Object v;
        Object s = subj;
        if (subj instanceof String) {
            s = this.makeNP((String)subj);
        }
        if ((v = verb) instanceof String) {
            v = this.getComplexVerb((String)v);
        }
        return new SPhraseSpec(s, v);
    }

    public SPhraseSpec makeS(Object subj, Object verb, Object comp) {
        SPhraseSpec s = this.makeS(subj, verb);
        Object c = comp;
        if (c instanceof String) {
            c = this.makeNP((String)comp);
        }
        s.setComplement(c);
        return s;
    }

    public NPPhraseSpec makePronounNP(String pro) {
        Pronoun p = Constants.getPronoun(pro);
        if (p != null) {
            return this.makePronounNP(p);
        }
        return new NPPhraseSpec(pro);
    }

    public NPPhraseSpec makePronounNP(Pronoun pro) {
        NPPhraseSpec np = new NPPhraseSpec(pro);
        if (Constants.requiresPlural(pro)) {
            np.setPlural(true);
        }
        return np;
    }

    public NPPhraseSpec makePronounNP(Person p, NumberAgr n) {
        NPPhraseSpec np = new NPPhraseSpec(Constants.getPersonalPronoun(p));
        if (n == NumberAgr.PLURAL) {
            np.setPlural(true);
        }
        return np;
    }

    public NPPhraseSpec makePronounNP(Person p, NumberAgr n, Gender g) {
        NPPhraseSpec np = this.makePronounNP(p, n);
        np.setGender(g);
        return np;
    }

    private void addSymbols() {
        for (String symb : WordLists.SYMBOLS) {
            this.addItem(Category.SYMBOL, symb);
        }
    }

    private void addAuxVerbs() {
        for (String v : WordLists.AUXILIARIES) {
            Verb verb = new Verb(v);
            verb.setVerbType(VerbType.AUX);
            this.addItem(verb);
        }
    }

    private void addModals() {
        for (String v : WordLists.MODALS) {
            Verb verb = new Verb(v);
            verb.setVerbType(VerbType.MODAL);
            verb.setInflectionType(InflectionType.INVARIANT);
            this.addItem(verb);
        }
    }

    private void addConsDoublingVerbs() {
        for (String v : WordLists.VERB_CONS_DOUBLING) {
            Verb verb = new Verb(v);
            verb.setVerbType(VerbType.MAIN);
            this.addItem(verb);
        }
    }

    private void addInvariantNouns() {
        for (String n : WordLists.NULL_PLURAL) {
            Noun noun = new Noun(n);
            noun.setInflectionType(InflectionType.INVARIANT);
            this.addItem(noun);
        }
    }

    private void addDeterminers() {
        for (Determiner d : Constants.ALL_DETERMINERS) {
            this.addItem(d);
        }
    }

    private void addConjunctions() {
        for (Conjunction c : Constants.ALL_CONJUNCTIONS) {
            this.addItem(c);
        }
    }

    private void addPronouns() {
        for (Pronoun p : Constants.ALL_PRONOUNS) {
            this.addItem(p);
        }
    }

    private void addAdjectives() {
        for (Adjective a : Adjectives.ALL_ADJECTIVES) {
            a.setParentLexicon(this);
        }
    }

    private void addNouns() {
        for (Noun n : Nouns.ALL_NOUNS) {
            n.setParentLexicon(this);
        }
    }

    private void addVerbs() {
        Verb[][] verbLists;
        Verb[][] arr$ = verbLists = new Verb[][]{Verbs.ALL_VERBS, Constants.ALL_AUXILIARIES, Constants.ALL_MODALS};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Verb[] vl;
            for (Verb v : vl = arr$[i$]) {
                v.setParentLexicon(this);
            }
        }
    }

    private String makeID() {
        String number = String.valueOf(this.getNumberOfItems());
        return this.idPrefix + number;
    }
}

