#include <fstream>

#include "include/basic.h"
#include "io/token_manager.h"
#include "weight_second_order.h"

WeightSecondOrder::WeightSecondOrder(const std::string& input_file,
                                     const std::string& output_file)
: WeightBase(input_file, output_file),
  is_top("is_top_"),
  lemma_dir_index("lemma_dir_index_"),
  label_dir_index("label_dir_index_"),
  label_lemma_dir_index("label_lemma_edge_index_"),
  edge_lemma_index("edge_lemma_index_"),
  edge_label_index("edge_label_index_"),
  edge_label_lemma_index("edge_label_lemma_index_"),
  label_edge_index("label_edge_index_"),
  lemma_edge_index("lemma_edge_index_"),
  label_lemma_edge_index("label_lemma_edge_index_"),
  node2_dir_index("node2_dir_index"),
  lemma2_dir_index("lemma2_dir_index"),
  node2_lemma2_dir_index("node2_lemma2_dir_index") {
    WeightBase::loadScores();
    LOG_INFO(<< "Features load complete");
}

void WeightSecondOrder::loadScores(std::istream& is) {
    is >> TokenManager::lemmas();
    is >> TokenManager::senses();
    is >> TokenManager::nodeLabels();
    is >> TokenManager::edgeLabels();

    is >> is_top;

    is >> lemma_dir_index;
    is >> label_dir_index;
    is >> label_lemma_dir_index;

    is >> edge_lemma_index;
    is >> edge_label_index;
    is >> edge_label_lemma_index;

    is >> label_edge_index;
    is >> lemma_edge_index;
    is >> label_lemma_edge_index;

    is >> node2_dir_index;
    is >> lemma2_dir_index;
    is >> node2_lemma2_dir_index;
}

void WeightSecondOrder::saveScores(std::ostream& os) const {
    os << TokenManager::lemmas();
    os << TokenManager::senses();
    os << TokenManager::nodeLabels();
    os << TokenManager::edgeLabels();

    os << is_top;

    os << lemma_dir_index;
    os << label_dir_index;
    os << label_lemma_dir_index;

    os << edge_lemma_index;
    os << edge_label_index;
    os << edge_label_lemma_index;

    os << label_edge_index;
    os << lemma_edge_index;
    os << label_lemma_edge_index;

    os << node2_dir_index;
    os << lemma2_dir_index;
    os << node2_lemma2_dir_index;
}

void WeightSecondOrder::computeAverageFeatureWeights(const int& round) {
    is_top.computeAverage(round);

    lemma_dir_index.computeAverage(round);
    label_dir_index.computeAverage(round);
    label_lemma_dir_index.computeAverage(round);

    edge_lemma_index.computeAverage(round);
    edge_label_index.computeAverage(round);
    edge_label_lemma_index.computeAverage(round);

    label_edge_index.computeAverage(round);
    lemma_edge_index.computeAverage(round);
    label_lemma_edge_index.computeAverage(round);

    node2_dir_index.computeAverage(round);
    lemma2_dir_index.computeAverage(round);
    node2_lemma2_dir_index.computeAverage(round);
}
