#ifndef SOLVER_H
#define SOLVER_H

#include "macros_base.h"
#include "dag_transducer_base.h"

class EquationSolverBase {
private:
    DAGTransducerBase* transducer_ptr_;

    int pron_index = -1;
    int poss_index = -1;
    int sense_1_index = -1;
    int parentheical_index = -1;

protected:
    void solveVariable(int node_index, int var_index, std::string& result);

    void computeSpecialLemma(const EdsGraph::Node& node,
                             int node_index,
                             std::string& result);

public:
    EquationSolverBase(DAGTransducerBase* transducer)
    : transducer_ptr_(transducer) {}

    void solve(std::string& result);

    void initialize();
};

#endif /* SOLVER_H */

// Local Variables:
// mode: c++
// End:
