/*
 * Decompiled with CFR 0.152.
 */
package org.ardverk.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.ardverk.collection.Cursor;
import org.ardverk.collection.Trie;

public class Tries {
    static boolean isOutOfBoundsIndex(int n) {
        return n == -3;
    }

    static boolean isEqualBitKey(int n) {
        return n == -2;
    }

    static boolean isNullBitKey(int n) {
        return n == -1;
    }

    static boolean isValidBitIndex(int n) {
        return 0 <= n && n <= Integer.MAX_VALUE;
    }

    static boolean areEqual(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    static <T> T notNull(T t, String string) {
        if (t == null) {
            throw new NullPointerException(string);
        }
        return t;
    }

    static <K> K cast(Object object) {
        return (K)object;
    }

    private Tries() {
    }

    public static <K, V> Trie<K, V> synchronizedTrie(Trie<K, V> trie) {
        if (trie instanceof SynchronizedTrie) {
            return trie;
        }
        return new SynchronizedTrie<K, V>(trie);
    }

    public static <K, V> Trie<K, V> unmodifiableTrie(Trie<K, V> trie) {
        if (trie instanceof UnmodifiableTrie) {
            return trie;
        }
        return new UnmodifiableTrie<K, V>(trie);
    }

    private static class UnmodifiableTrie<K, V>
    implements Trie<K, V>,
    Serializable {
        private static final long serialVersionUID = -7156426030315945159L;
        private final Trie<K, V> delegate;

        public UnmodifiableTrie(Trie<K, V> trie) {
            this.delegate = Tries.notNull(trie, "delegate");
        }

        @Override
        public Map.Entry<K, V> select(K k, final Cursor<? super K, ? super V> cursor) {
            Cursor cursor2 = new Cursor<K, V>(){

                @Override
                public Cursor.Decision select(Map.Entry<? extends K, ? extends V> entry) {
                    Cursor.Decision decision = cursor.select(entry);
                    switch (decision) {
                        case REMOVE: 
                        case REMOVE_AND_EXIT: {
                            throw new UnsupportedOperationException();
                        }
                    }
                    return decision;
                }
            };
            return this.delegate.select(k, cursor2);
        }

        @Override
        public Map.Entry<K, V> select(K k) {
            return this.delegate.select(k);
        }

        @Override
        public K selectKey(K k) {
            return this.delegate.selectKey(k);
        }

        @Override
        public V selectValue(K k) {
            return this.delegate.selectValue(k);
        }

        @Override
        public Map.Entry<K, V> traverse(final Cursor<? super K, ? super V> cursor) {
            Cursor cursor2 = new Cursor<K, V>(){

                @Override
                public Cursor.Decision select(Map.Entry<? extends K, ? extends V> entry) {
                    Cursor.Decision decision = cursor.select(entry);
                    switch (decision) {
                        case REMOVE: 
                        case REMOVE_AND_EXIT: {
                            throw new UnsupportedOperationException();
                        }
                    }
                    return decision;
                }
            };
            return this.delegate.traverse(cursor2);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.unmodifiableSet(this.delegate.entrySet());
        }

        @Override
        public Set<K> keySet() {
            return Collections.unmodifiableSet(this.delegate.keySet());
        }

        @Override
        public Collection<V> values() {
            return Collections.unmodifiableCollection(this.delegate.values());
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.delegate.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.delegate.containsValue(object);
        }

        @Override
        public V get(Object object) {
            return this.delegate.get(object);
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public V put(K k, V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public K firstKey() {
            return this.delegate.firstKey();
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            return Collections.unmodifiableSortedMap(this.delegate.headMap(k));
        }

        @Override
        public K lastKey() {
            return this.delegate.lastKey();
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            return Collections.unmodifiableSortedMap(this.delegate.subMap(k, k2));
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            return Collections.unmodifiableSortedMap(this.delegate.tailMap(k));
        }

        @Override
        public SortedMap<K, V> prefixMap(K k) {
            return Collections.unmodifiableSortedMap(this.delegate.prefixMap(k));
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.delegate.comparator();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return this.delegate.equals(object);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private static class SynchronizedSortedMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 3654589935305688739L;
        private final Object lock;
        private final SortedMap<K, V> delegate;

        public SynchronizedSortedMap(Object object, SortedMap<K, V> sortedMap) {
            this.lock = Tries.notNull(object, "lock");
            this.delegate = Tries.notNull(sortedMap, "delegate");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super K> comparator() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Object object = this.lock;
            synchronized (object) {
                return new SynchronizedSet<Map.Entry<K, V>>(this.lock, this.delegate.entrySet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K firstKey() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> headMap(K k) {
            Object object = this.lock;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.lock, this.delegate.headMap(k));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<K> keySet() {
            Object object = this.lock;
            synchronized (object) {
                return new SynchronizedSet<K>(this.lock, this.delegate.keySet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K lastKey() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.lastKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            Object object = this.lock;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.lock, this.delegate.subMap(k, k2));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> tailMap(K k) {
            Object object = this.lock;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.lock, this.delegate.tailMap(k));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            Object object = this.lock;
            synchronized (object) {
                return new SynchronizedCollection<V>(this.lock, this.delegate.values());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.lock;
            synchronized (object) {
                this.delegate.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return this.delegate.containsKey(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return this.delegate.containsValue(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return this.delegate.get(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(K k, V v) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Object object = this.lock;
            synchronized (object) {
                this.delegate.putAll(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return this.delegate.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            SortedMap<K, V> sortedMap = this.delegate;
            synchronized (sortedMap) {
                return this.delegate.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            SortedMap<K, V> sortedMap = this.delegate;
            synchronized (sortedMap) {
                return this.delegate.equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.toString();
            }
        }
    }

    private static class SynchronizedSet<E>
    extends SynchronizedCollection<E>
    implements Set<E> {
        private static final long serialVersionUID = -6998017897934241309L;

        public SynchronizedSet(Object object, Collection<E> collection) {
            super(object, collection);
        }
    }

    private static class SynchronizedCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 2625364158304884729L;
        private final Object lock;
        private final Collection<E> delegate;

        public SynchronizedCollection(Object object, Collection<E> collection) {
            this.lock = Tries.notNull(object, "lock");
            this.delegate = Tries.notNull(collection, "delegate");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E e) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.add(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> collection) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.addAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.lock;
            synchronized (object) {
                this.delegate.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return this.delegate.contains(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> collection) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.containsAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<E> iterator() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return this.delegate.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> collection) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.removeAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> collection) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.retainAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] TArray) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.toArray(TArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Collection<E> collection = this.delegate;
            synchronized (collection) {
                return ((Object)this.delegate).hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            Collection<E> collection = this.delegate;
            synchronized (collection) {
                return ((Object)this.delegate).equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.toString();
            }
        }
    }

    private static class SynchronizedTrie<K, V>
    implements Trie<K, V>,
    Serializable {
        private static final long serialVersionUID = 3121878833178676939L;
        private final Trie<K, V> delegate;

        public SynchronizedTrie(Trie<K, V> trie) {
            this.delegate = Tries.notNull(trie, "delegate");
        }

        @Override
        public synchronized Map.Entry<K, V> select(K k, Cursor<? super K, ? super V> cursor) {
            return this.delegate.select((K)k, cursor);
        }

        @Override
        public synchronized Map.Entry<K, V> select(K k) {
            return this.delegate.select(k);
        }

        @Override
        public synchronized K selectKey(K k) {
            return this.delegate.selectKey(k);
        }

        @Override
        public synchronized V selectValue(K k) {
            return this.delegate.selectValue(k);
        }

        @Override
        public synchronized Map.Entry<K, V> traverse(Cursor<? super K, ? super V> cursor) {
            return this.delegate.traverse(cursor);
        }

        @Override
        public synchronized Set<Map.Entry<K, V>> entrySet() {
            return new SynchronizedSet(this, this.delegate.entrySet());
        }

        @Override
        public synchronized Set<K> keySet() {
            return new SynchronizedSet(this, this.delegate.keySet());
        }

        @Override
        public synchronized Collection<V> values() {
            return new SynchronizedCollection(this, this.delegate.values());
        }

        @Override
        public synchronized void clear() {
            this.delegate.clear();
        }

        @Override
        public synchronized boolean containsKey(Object object) {
            return this.delegate.containsKey(object);
        }

        @Override
        public synchronized boolean containsValue(Object object) {
            return this.delegate.containsValue(object);
        }

        @Override
        public synchronized V get(Object object) {
            return this.delegate.get(object);
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public synchronized V put(K k, V v) {
            return this.delegate.put(k, v);
        }

        @Override
        public synchronized void putAll(Map<? extends K, ? extends V> map) {
            this.delegate.putAll(map);
        }

        @Override
        public synchronized V remove(Object object) {
            return this.delegate.remove(object);
        }

        @Override
        public synchronized K lastKey() {
            return this.delegate.lastKey();
        }

        @Override
        public synchronized SortedMap<K, V> subMap(K k, K k2) {
            return new SynchronizedSortedMap(this, this.delegate.subMap(k, k2));
        }

        @Override
        public synchronized SortedMap<K, V> tailMap(K k) {
            return new SynchronizedSortedMap(this, this.delegate.tailMap(k));
        }

        @Override
        public synchronized Comparator<? super K> comparator() {
            return this.delegate.comparator();
        }

        @Override
        public synchronized K firstKey() {
            return this.delegate.firstKey();
        }

        @Override
        public synchronized SortedMap<K, V> headMap(K k) {
            return new SynchronizedSortedMap(this, this.delegate.headMap(k));
        }

        @Override
        public synchronized SortedMap<K, V> prefixMap(K k) {
            return new SynchronizedSortedMap<K, V>(this, this.delegate.prefixMap(k));
        }

        @Override
        public synchronized int size() {
            return this.delegate.size();
        }

        @Override
        public synchronized int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public synchronized boolean equals(Object object) {
            return this.delegate.equals(object);
        }

        public synchronized String toString() {
            return this.delegate.toString();
        }
    }
}

