/*
 * Decompiled with CFR 0.152.
 */
package org.ardverk.collection;

import java.io.Serializable;
import org.ardverk.collection.AbstractKeyAnalyzer;

public class ShortKeyAnalyzer
extends AbstractKeyAnalyzer<Short>
implements Serializable {
    private static final long serialVersionUID = 5263816158638832817L;
    public static final ShortKeyAnalyzer INSTANCE = new ShortKeyAnalyzer();
    private static final int MSB = 32768;

    private static int mask(int n) {
        return 32768 >>> n;
    }

    @Override
    public int lengthInBits(Short s) {
        return 8;
    }

    @Override
    public boolean isBitSet(Short s, int n) {
        return (s & ShortKeyAnalyzer.mask(n)) != 0;
    }

    @Override
    public int bitIndex(Short s, Short s2) {
        short s3 = s;
        if (s3 == 0) {
            return -1;
        }
        short s4 = s2;
        if (s3 != s4) {
            int n = s3 ^ s4;
            for (int i = 0; i < 16; ++i) {
                if ((n & ShortKeyAnalyzer.mask(i)) == 0) continue;
                return i;
            }
        }
        return -2;
    }

    @Override
    public boolean isPrefix(Short s, Short s2) {
        return s.equals(s2);
    }
}

