clc
clear
%%%%%%data
disp('Train the RL-DNN-LM on ptb database');
%%%%%%%%%
%% Data prepcessing
para.n_words         = 2; 
para.vecSize         = 200;
word2vector_init_method  = 'random'; %random skip_gram
[D] = DataProcessing(para.vecSize,para.n_words, word2vector_init_method);
%load('ptb100.n_words2.mat');
%%%%%%%%%% parameters setting
para.lrate           = 0.4;
para.batchSize       = 200;
para.momentum        = 0.9;
para.wdr             = 0.00004;
para.NNsize          = [para.vecSize*para.n_words,400,400,D.codeBookSize]; %% net architecture
para
%%%%%%%%%%training
[net,codeBook, obj] = RL_DNN_LM(D, para);
%%%%%%%%%%save
nLayers = length(para.NNsize);
w = cell(1,nLayers-1);
bias = cell(1,nLayers-1);
for iLayer = 1 : nLayers-1
    w{iLayer} = gather(net.w{iLayer});
    bias{iLayer} = gather(net.b{iLayer});
end
%fname=datestr(now);
fname = sprintf('./rec/ptb_%dgram_vecSize%d_lr%.2f_b%d_2hid400_%s',para.vecSize,para.n_words,para.lrate,para.batchSize,word2vector_init_method);
save(fname, 'w', 'bias','obj','para','codeBook') ;   