/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.modification.morefeatures;

import edu.pku.coli.io.DAGSentenceReader;
import edu.pku.coli.pear.dag.SentenceForDAGParsing;
import java.util.Iterator;
import java.util.List;
import matetools.is2.data.D6;
import matetools.is2.data.DX;
import matetools.is2.data.Instances;
import matetools.is2.data.Long2IntInterface;
import matetools.is2.data.SentenceData09;
import matetools.is2.modification.morefeatures.MoreFeaturesInterface;
import matetools.is2.parser.D5;
import matetools.is2.parser.Extractor;

public class DepTreeFeatures
extends MoreFeaturesInterface {
    static String FIRST_LETTER_OF_POS = "FLPOS";
    Iterator<SentenceForDAGParsing> sents;
    String trainDep;
    String testDep;
    String format;
    int lca_flp;
    int lca_pos;
    private int what;

    public DepTreeFeatures(String trainDep, String testDep, String format) {
        this.trainDep = trainDep;
        this.testDep = testDep;
        this.format = format;
    }

    private DAGSentenceReader getReader(String dir) {
        if (this.format.equalsIgnoreCase("conll08")) {
            return DAGSentenceReader.treesReaderFromCoNLL08(dir);
        }
        if (this.format.equalsIgnoreCase("conll06")) {
            return DAGSentenceReader.treesReaderFromCoNLL06(dir);
        }
        throw new RuntimeException("Unknown dependency tree format: " + this.format);
    }

    @Override
    public void register() {
        while (this.sents.hasNext()) {
            SentenceForDAGParsing s = this.sents.next();
            String[] stringArray = s.tags();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pos = stringArray[n2];
                this.mf.register(FIRST_LETTER_OF_POS, pos.substring(0, 1));
                ++n2;
            }
        }
    }

    @Override
    public void init(int what) {
        this.what = what;
    }

    @Override
    public void initFeats() {
        this.lca_flp = this.mf.register(FIRST_LETTER_OF_POS, "<LCA>");
        this.lca_pos = this.mf.register("POS", "<LCA>");
        int i = 0;
        while (i < 10) {
            this.mf.register("TYPE", "DepTree" + i);
            ++i;
        }
        this.featureIndex = this.mf.getFeatureCounter().get("TYPE") - 8;
    }

    @Override
    public void createFeatures(Instances is, SentenceData09 instance) {
        SentenceForDAGParsing sent = this.sents.next();
        int sentLen = sent.numOfWords();
        short[] flp = new short[sentLen + 1];
        flp[0] = (short)this.mf.getValue(FIRST_LETTER_OF_POS, "ROOT");
        int i = 0;
        while (i < sentLen) {
            flp[i + 1] = (short)this.mf.getValue(FIRST_LETTER_OF_POS, sent.tags()[i].substring(0, 1));
            ++i;
        }
        int[] depTree = new int[sentLen + 1];
        depTree[0] = -1;
        int i2 = 1;
        while (i2 <= sentLen) {
            depTree[i2] = sent.getGoldDAG().getAdjacencyLists()[i2].getInArcs().get((int)0).index;
            ++i2;
        }
        if (is.moreIntFeats[is.size() - 1] == null) {
            is.moreIntFeats[is.size() - 1] = new MoreFeaturesInterface.MoreIntFeats(new IntDepTree(flp, depTree));
        } else {
            is.moreIntFeats[is.size() - 1].depTree = new IntDepTree(flp, depTree);
        }
    }

    @Override
    public void addFirstOrderFeatures(Instances is, int ins, int w1, int w2, int label, List<Long> ret) {
        this.addFirstOrderFeaturesHelperFull(is, ins, w1, w2, label, ret, this.featureIndex);
    }

    public void addFirstOrderFeaturesHelper(Instances is, int ins, int w1, int w2, int label, List<Long> ret, int n) {
        DX d3;
        DX d2;
        DX d1;
        DX d0;
        Long2IntInterface l2i = MoreFeaturesInterface.l2i;
        if (this.what == 1) {
            d0 = new D6(l2i);
            d1 = new D6(l2i);
            d2 = new D6(l2i);
            d3 = new D6(l2i);
        } else {
            d0 = new D5(l2i);
            d1 = new D5(l2i);
            d2 = new D5(l2i);
            d3 = new D5(l2i);
        }
        d0.a0 = Extractor.s_type;
        d0.a1 = Extractor.s_rel;
        d0.a2 = Extractor.s_pos;
        d0.a3 = Extractor.s_pos;
        d0.a4 = Extractor.s_pos;
        d0.a5 = Extractor.s_pos;
        d0.a6 = Extractor.s_pos;
        d0.a7 = Extractor.s_pos;
        d0.a8 = Extractor.s_pos;
        d0.a9 = Extractor.s_pos;
        d0.fix();
        d1.a0 = Extractor.s_type;
        d1.a1 = Extractor.s_rel;
        d1.a2 = Extractor.s_word;
        d1.a3 = Extractor.s_word;
        d1.a4 = Extractor.s_pos;
        d1.a5 = Extractor.s_pos;
        d1.a6 = Extractor.s_pos;
        d1.a7 = Extractor.s_pos;
        d1.a8 = Extractor.s_pos;
        d1.a9 = Extractor.s_pos;
        d1.fix();
        d2.a0 = Extractor.s_type;
        d2.a1 = Extractor.s_rel;
        int nflp = this.mf.getFeatureCounter().get(FIRST_LETTER_OF_POS);
        d2.a2 = nflp;
        d2.a3 = nflp;
        d2.a4 = nflp;
        d2.a5 = nflp;
        d2.a6 = nflp;
        d2.a7 = nflp;
        d2.a8 = nflp;
        d2.a9 = nflp;
        d2.fix();
        d3.a0 = Extractor.s_type;
        d3.a1 = Extractor.s_rel;
        d3.a2 = Extractor.s_word;
        d3.a3 = Extractor.s_word;
        d3.a4 = nflp;
        d3.a5 = nflp;
        d3.a6 = nflp;
        d3.a7 = nflp;
        d3.a8 = nflp;
        d3.a9 = nflp;
        d3.fix();
        IntDepTree depTree = is.moreIntFeats[ins].depTree;
        int[] tree = depTree.depTree;
        int[] w1ToRoot = new int[tree.length];
        int[] w2ToRoot = new int[tree.length];
        int w = w1;
        int j = 0;
        while (tree[w] != -1) {
            w1ToRoot[j++] = w;
            w = tree[w];
        }
        w1ToRoot[j] = -1;
        w = w2;
        j = 0;
        while (tree[w] != -1) {
            w2ToRoot[j++] = w;
            w = tree[w];
        }
        w2ToRoot[j] = -1;
        int[] path = new int[tree.length * 2];
        int p = 0;
        int i = 0;
        block14: while (w1ToRoot[i] != -1) {
            path[p++] = w1ToRoot[i];
            j = 0;
            while (w2ToRoot[j] != -1) {
                if (w1ToRoot[i] == w2ToRoot[j]) break block14;
                ++j;
            }
            ++i;
        }
        path[p++] = -1;
        i = j - 1;
        while (i >= 0) {
            path[p++] = w2ToRoot[i];
            --i;
        }
        path[p] = -2;
        short[] pos = is.pposs[ins];
        int[] v = new int[10];
        v[0] = n;
        v[1] = label;
        p = 0;
        while (p < 8 && path[p] != -2) {
            v[p + 2] = path[p] == -1 ? this.lca_pos : pos[path[p]];
            ++p;
        }
        d0.v0 = v[0];
        d0.v1 = v[1];
        d0.v2 = v[2];
        d0.v3 = v[3];
        d0.v4 = v[4];
        d0.v5 = v[5];
        d0.v6 = v[6];
        d0.v7 = v[7];
        d0.v8 = v[8];
        d0.v9 = v[9];
        switch (p) {
            case 2: {
                d0.cz4();
                ret.add(d0.getVal());
                break;
            }
            case 3: {
                d0.cz5();
                ret.add(d0.getVal());
                break;
            }
            case 4: {
                d0.cz6();
                ret.add(d0.getVal());
                break;
            }
            case 5: {
                d0.cz7();
                ret.add(d0.getVal());
                break;
            }
            default: {
                d0.cz8();
                ret.add(d0.getVal());
            }
        }
        v[0] = v[0] + 1;
        pos = is.moreIntFeats[ins].depTree.firstLettersOfPos;
        p = 0;
        while (p < 8 && path[p] != -2) {
            v[p + 2] = path[p] == -1 ? this.lca_flp : pos[path[p]];
            ++p;
        }
        d2.v0 = v[0];
        d2.v1 = v[1];
        d2.v2 = v[2];
        d2.v3 = v[3];
        d2.v4 = v[4];
        d2.v5 = v[5];
        d2.v6 = v[6];
        d2.v7 = v[7];
        d2.v8 = v[8];
        d2.v9 = v[9];
        switch (p) {
            case 2: {
                d2.cz4();
                ret.add(d2.getVal());
                break;
            }
            case 3: {
                d2.cz5();
                ret.add(d2.getVal());
                break;
            }
            case 4: {
                d2.cz6();
                ret.add(d2.getVal());
                break;
            }
            case 5: {
                d2.cz7();
                ret.add(d2.getVal());
                break;
            }
            default: {
                d2.cz8();
                ret.add(d2.getVal());
            }
        }
    }

    public void addFirstOrderFeaturesHelperFull(Instances is, int ins, int w1, int w2, int label, List<Long> ret, int n) {
        IntDepTree depTree = is.moreIntFeats[ins].depTree;
        int[] tree = depTree.depTree;
        int[] w1ToRoot = new int[tree.length];
        int[] w2ToRoot = new int[tree.length];
        int w = w1;
        int l1 = 0;
        while (tree[w] != -1) {
            w1ToRoot[l1++] = w;
            w = tree[w];
        }
        w = w2;
        int l2 = 0;
        while (tree[w] != -1) {
            w2ToRoot[l2++] = w;
            w = tree[w];
        }
        int i1 = l1 - 1;
        int i2 = l2 - 1;
        while (i1 >= 0 && i2 >= 0 && w1ToRoot[i1] == w2ToRoot[i2]) {
            --i1;
            --i2;
        }
        int[] path = new int[i1 + i2 + 4];
        System.arraycopy(w1ToRoot, 0, path, 0, i1 + 2);
        path[i1 + 2] = -1;
        int i = i2;
        while (i >= 0) {
            path[i1 + i2 - i + 3] = w2ToRoot[i];
            --i;
        }
        short[] pos = is.pposs[ins];
        long a = 1L;
        long t = n++;
        t += (a *= (long)Extractor.s_type) * (long)label;
        a *= (long)Extractor.s_rel;
        int i3 = 0;
        while (i3 < path.length) {
            t = path[i3] != -1 ? (t += a * (long)pos[path[i3]]) : (t += a * (long)this.lca_pos);
            a *= (long)Extractor.s_pos;
            ++i3;
        }
        ret.add(t);
        a = 1L;
        t = n++;
        t += (a *= (long)Extractor.s_type) * (long)label;
        t += (a *= (long)Extractor.s_rel) * (long)is.forms[ins][w1];
        t += (a *= (long)Extractor.s_word) * (long)is.forms[ins][w2];
        a *= (long)Extractor.s_word;
        i3 = 0;
        while (i3 < path.length) {
            t = path[i3] != -1 ? (t += a * (long)pos[path[i3]]) : (t += a * (long)this.lca_pos);
            a *= (long)Extractor.s_pos;
            ++i3;
        }
        ret.add(t);
        pos = is.moreIntFeats[ins].depTree.firstLettersOfPos;
        a = 1L;
        t = n++;
        t += (a *= (long)Extractor.s_type) * (long)label;
        a *= (long)Extractor.s_rel;
        i3 = 0;
        while (i3 < path.length) {
            t = path[i3] != -1 ? (t += a * (long)pos[path[i3]]) : (t += a * (long)this.lca_pos);
            a *= (long)Extractor.s_pos;
            ++i3;
        }
        ret.add(t);
        a = 1L;
        t = n++;
        t += (a *= (long)Extractor.s_type) * (long)label;
        t += (a *= (long)Extractor.s_rel) * (long)is.forms[ins][w1];
        t += (a *= (long)Extractor.s_word) * (long)is.forms[ins][w2];
        a *= (long)Extractor.s_word;
        i3 = 0;
        while (i3 < path.length) {
            t = path[i3] != -1 ? (t += a * (long)pos[path[i3]]) : (t += a * (long)this.lca_pos);
            a *= (long)Extractor.s_pos;
            ++i3;
        }
        ret.add(t);
    }

    @Override
    public void startReadingTrain() {
        this.sents = this.getReader(this.trainDep).iterator();
    }

    @Override
    public void startReadingTest() {
        this.sents = this.getReader(this.testDep).iterator();
    }

    static class IntDepTree {
        int[] depTree;
        short[] firstLettersOfPos;

        public IntDepTree(short[] flp, int[] depTree) {
            this.firstLettersOfPos = flp;
            this.depTree = depTree;
        }
    }
}

