/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tokenizer;

import com.aliasi.tokenizer.ModifiedTokenizerFactory;
import com.aliasi.tokenizer.ModifyTokenTokenizerFactory;
import com.aliasi.tokenizer.TokenizerFactory;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StopTokenizerFactory
extends ModifyTokenTokenizerFactory
implements Serializable {
    static final long serialVersionUID = -69680626775848410L;
    private final Set<String> mStopSet;

    public StopTokenizerFactory(TokenizerFactory factory, Set<String> stopSet) {
        super(factory);
        this.mStopSet = new HashSet<String>(stopSet);
    }

    public Set<String> stopSet() {
        return Collections.unmodifiableSet(this.mStopSet);
    }

    @Override
    public String modifyToken(String token) {
        return this.mStopSet.contains(token) ? null : token;
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Serializer
    extends ModifiedTokenizerFactory.AbstractSerializer<StopTokenizerFactory> {
        static final long serialVersionUID = 1555788949118743254L;

        public Serializer() {
            this(null);
        }

        public Serializer(StopTokenizerFactory factory) {
            super(factory);
        }

        @Override
        public void writeExternalRest(ObjectOutput out) throws IOException {
            out.writeInt(((StopTokenizerFactory)this.factory()).mStopSet.size());
            for (String stop : ((StopTokenizerFactory)this.factory()).mStopSet) {
                out.writeUTF(stop);
            }
        }

        @Override
        public Object read(ObjectInput in, TokenizerFactory baseFactory) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            HashSet<String> stopSet = new HashSet<String>();
            for (int i = 0; i < size; ++i) {
                stopSet.add(in.readUTF());
            }
            return new StopTokenizerFactory(baseFactory, stopSet);
        }
    }
}

